/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2.ui;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.javatools.ui.table.GenericTable;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdevimpl.vcs.perforce2.res.PerforceArb;
import oracle.jdevimpl.vcs.perforce2.ui.PerforceFinish;
import oracle.jdevimpl.vcs.perforce2.util.ClientInfo;
import oracle.jdevimpl.vcs.perforce2.util.PerforceCommands;

public class PerforceClientPanel
extends JPanel
implements PerforceFinish {
    private String _user;
    private String _server;
    private JComboBox _users = new JComboBox();
    private GenericTable _table;
    private Map<String, List> _clients = new HashMap<String, List>();
    private Collection<PerforceFinish> _finish = new ArrayList<PerforceFinish>();

    public PerforceClientPanel(String user, String server) {
        this._user = user;
        this._server = server;
        try {
            this.createComboModel();
            this.createTableModel();
            this.addListener();
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        Insets ins = new Insets(5, 5, 5, 5);
        this.setLayout(new GridBagLayout());
        this.add((Component)this._users, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, ins, 0, 0));
        this.add((Component)new JScrollPane((Component)this._table), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, ins, 0, 0));
    }

    Component getDefaultComponent() {
        return this._table;
    }

    private void createComboModel() {
        String name = PerforceArb.format("CLIENT_BY_USER", this.getUser());
        String all = PerforceArb.get("CLIENT_BY_ALL");
        DefaultComboBoxModel<ComboBoxData> model = new DefaultComboBoxModel<ComboBoxData>(new ComboBoxData[]{new ComboBoxData(name, true), new ComboBoxData(all, false)});
        this._users.setModel(model);
        this._clients.put(name, null);
        this._clients.put(all, null);
        model.setSelectedItem(name);
    }

    private String getUser() {
        return this._user;
    }

    private String getServer() {
        return this._server;
    }

    private void addListener() {
        this._users.addActionListener(new ClientActionListener());
    }

    private void createTableModel() {
        ClientTableModel model = new ClientTableModel();
        this._table = new GenericTable((TableModel)model);
        this._table.setSelectionMode(0);
        ComboBoxData data = (ComboBoxData)this._users.getModel().getElementAt(0);
        this.populateClients(data._label, data._userClientsOnly);
        this._table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ClientTableModel model = (ClientTableModel)PerforceClientPanel.this._table.getModel();
                if (PerforceClientPanel.this._table.getSelectedRowInModel() < 0) {
                    PerforceClientPanel.this.canFinish(false);
                    return;
                }
                Object obj = model.getDataAt(PerforceClientPanel.this._table.getSelectedRowInModel());
                if (obj instanceof NoClientData) {
                    PerforceClientPanel.this._table.clearSelection();
                    PerforceClientPanel.this.canFinish(false);
                } else {
                    PerforceClientPanel.this.canFinish(true);
                }
            }
        });
    }

    private void populateClients(final String item, final boolean userClientsOnly) {
        if (this._clients.get(item) == null) {
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    IndeterminateProgressMonitor monitor = new IndeterminateProgressMonitor((Component)VCSWindowUtils.getCurrentWindow(), PerforceArb.get("CONNECT_PERFORCE_LIST"));
                    try {
                        monitor.setCloseOnFinish(true);
                        monitor.setMillisToPopup(500);
                        monitor.start();
                        Map<String, ClientInfo> clInfo = PerforceCommands.getUserClientSpec(PerforceClientPanel.this.getUser(), PerforceClientPanel.this.getServer(), userClientsOnly);
                        if (clInfo.values().size() == 0) {
                            ArrayList<NoClientData> data = new ArrayList<NoClientData>();
                            data.add(new NoClientData());
                            PerforceClientPanel.this._clients.put(item, data);
                        } else {
                            PerforceClientPanel.this._clients.put(item, new ArrayList<ClientInfo>(clInfo.values()));
                        }
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ((ClientTableModel)PerforceClientPanel.this._table.getModel()).addValues((List)PerforceClientPanel.this._clients.get(item));
                            }
                        });
                    }
                    catch (Exception f) {
                        f.printStackTrace();
                    }
                    finally {
                        monitor.finish();
                    }
                }
            }, "PerforceClient").start();
        } else {
            ((ClientTableModel)this._table.getModel()).addValues(this._clients.get(item));
        }
    }

    String getClient() {
        ClientTableModel model = (ClientTableModel)this._table.getModel();
        return model.getClientAt(this._table.getSelectedRowInModel());
    }

    @Override
    public void canFinish(boolean finish) {
        Iterator<PerforceFinish> it = this._finish.iterator();
        while (it.hasNext()) {
            it.next().canFinish(finish);
        }
    }

    void addFinishListener(PerforceFinish perforceFinish) {
        this._finish.add(perforceFinish);
    }

    private class NoClientData
    extends ClientInfo {
        NoClientData() {
            super(PerforceArb.get("CONNECTION_NO_CLIENTS"), null);
        }
    }

    private class ComboBoxData {
        String _label;
        boolean _userClientsOnly;

        private ComboBoxData(String label, boolean userClientsOnly) {
            this._label = label;
            this._userClientsOnly = userClientsOnly;
        }

        public String toString() {
            return this._label;
        }
    }

    private class ClientTableModel
    extends AbstractTableModel {
        private List<ClientInfo> _data = Collections.emptyList();
        String[] colNames = new String[]{PerforceArb.get("TABLE_COL_NAME"), PerforceArb.get("TABLE_COL_DESCRIPTION")};

        private ClientTableModel() {
        }

        @Override
        public int getColumnCount() {
            return this.colNames.length;
        }

        @Override
        public String getColumnName(int column) {
            if (column >= this.colNames.length) {
                return null;
            }
            return this.colNames[column];
        }

        private void addValues(List<ClientInfo> clients) {
            if (this._data.size() > 0) {
                this.fireTableRowsDeleted(0, this._data.size());
            }
            this._data = clients;
            this.fireTableRowsInserted(0, this._data.size());
        }

        @Override
        public int getRowCount() {
            return this._data.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (rowIndex >= this._data.size()) {
                return null;
            }
            ClientInfo cl = this._data.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return cl.getName();
                }
                case 1: {
                    return cl.getDescription();
                }
            }
            return null;
        }

        private String getClientAt(int row) {
            return this._data.get(row).getName();
        }

        private Object getDataAt(int row) {
            return this._data.get(row);
        }
    }

    private class ClientActionListener
    implements ActionListener {
        private ClientActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ComboBoxData item = (ComboBoxData)((JComboBox)e.getSource()).getSelectedItem();
            PerforceClientPanel.this.populateClients(item._label, item._userClientsOnly);
        }
    }
}

