/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.ide.controls.checkboxlist.CheckBoxListModel;
import oracle.ide.dialogs.SelectFilesPanel;
import oracle.ide.runner.RunProcess;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.vcs.migrate.VCSStreamMonitor;
import oracle.jdeveloper.vcs.spi.VCSCommentsCustomizer;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceShellRunner;
import oracle.jdevimpl.vcs.perforce2.error.PerforceOperationException;
import oracle.jdevimpl.vcs.perforce2.error.PerforceProcessException;
import oracle.jdevimpl.vcs.perforce2.res.PerforceArb;
import oracle.jdevimpl.vcs.perforce2.util.ChangeListFile;
import oracle.jdevimpl.vcs.perforce2.util.PerforceUtil;

public class ChangeListPanel
extends JPanel {
    private static Logger sLogger = PerforceProfile.getQualifiedLogger(ChangeListPanel.class.getName());
    private GridBagLayout gridBagLayout = new GridBagLayout();
    private JLabel lblConnection = new JLabel();
    private JComboBox chbConnection;
    private VCSCommentsCustomizer _comments;
    private SelectFilesPanel filesPanel;
    private CheckBoxListModel model = new CheckBoxListModel();
    private JLabel lblChangeList = new JLabel();
    private JLabel lblFiles = new JLabel();
    private Collection<ChangeListFile> defaultCLFiles = new HashSet<ChangeListFile>();

    public ChangeListPanel(Collection<PerforceConnectionProfile> cons, VCSCommentsCustomizer comments) {
        this._comments = comments;
        this.chbConnection = new JComboBox();
        this.chbConnection.setModel(this.createComboBoxModel(cons));
        try {
            this.model = this.filesOnDefaultCL();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.filesPanel = new SelectFilesPanel(this.model, true);
        this.jbInit();
        this.addListener();
    }

    public ChangeListPanel(PerforceConnectionProfile con, Collection<ChangeListFile> clFiles, VCSCommentsCustomizer comments) {
        this._comments = comments;
        this.model = this.updateCheckBoxListModel(clFiles);
        this.filesPanel = new SelectFilesPanel(this.model, true);
        this.jbInit();
    }

    public void setFileHeader(String header) {
        if (this.filesPanel != null) {
            ResourceUtils.resLabel((JLabel)this.lblFiles, (Component)this.filesPanel, (String)header);
        }
    }

    public Component getDefaultComponent() {
        return this._comments.getInitialFocusComponent();
    }

    public String getDescription() {
        Map options = this._comments.getOptions();
        String commentOption = (String)options.get("setting_comments");
        return commentOption;
    }

    private void jbInit() {
        Insets ins = new Insets(2, 5, 3, 5);
        this.setLayout(this.gridBagLayout);
        if (this.chbConnection != null) {
            ResourceUtils.resLabel((JLabel)this.lblConnection, (Component)this.chbConnection, (String)PerforceArb.get("CHANGELIST_CONNECTION"));
        }
        int row = 0;
        if (this.chbConnection != null) {
            this.add((Component)this.lblConnection, new GridBagConstraints(0, row++, 1, 1, 0.0, 0.0, 17, 0, ins, 0, 0));
            this.add((Component)this.chbConnection, new GridBagConstraints(0, row++, 1, 1, 0.0, 0.0, 17, 2, ins, 0, 0));
        }
        this.add((Component)this.lblFiles, new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 3, 5), 0, 0));
        this.add((Component)this.filesPanel, new GridBagConstraints(0, row++, 1, 1, 1.0, 0.75, 17, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this.lblChangeList, new GridBagConstraints(0, row++, 1, 1, 0.0, 0.0, 17, 0, ins, 0, 0));
        this.add(this._comments.getComponent(), new GridBagConstraints(0, row++, 1, 1, 1.0, 0.25, 17, 1, ins, 0, 0));
    }

    public Collection<ChangeListFile> getCLFilesAndActions() {
        List selectedObjects = this.model.getSelectionList();
        if (selectedObjects == null) {
            return Collections.EMPTY_LIST;
        }
        return selectedObjects;
    }

    public Collection<ChangeListFile> getUnSelectedCLFilesAndActions() {
        List selectedObjects = this.model.getSelectionList();
        if (selectedObjects == null || selectedObjects.size() == this.model.getSize()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<ChangeListFile> clFiles = new ArrayList<ChangeListFile>();
        for (int r = 0; r < this.model.getSize(); ++r) {
            ChangeListFile clFile = (ChangeListFile)this.model.getUserObjectAt(r);
            if (selectedObjects.contains(clFile)) continue;
            clFiles.add(clFile);
        }
        return clFiles;
    }

    private CheckBoxListModel filesOnDefaultCL() throws Exception {
        PerforceConnectionProfile connect = (PerforceConnectionProfile)this.chbConnection.getSelectedItem();
        this.filesOnDefaultChangeList(connect);
        PerforceUtil.getWorkspaceFiles(connect, this.defaultCLFiles);
        PerforceUtil.getMovedFileDetails(connect, this.defaultCLFiles);
        this.model = this.updateCheckBoxListModel(this.defaultCLFiles);
        return this.model;
    }

    private void removeAllCheckBoxListModel() {
        this.model.clear();
    }

    private CheckBoxListModel updateCheckBoxListModel(Collection<ChangeListFile> files) {
        Iterator<ChangeListFile> it = files.iterator();
        boolean i = true;
        while (it.hasNext()) {
            ChangeListFile clFile = it.next();
            if (clFile.isMoveAddAction()) {
                this.model.addElement((Object)clFile, clFile.getIcon(), clFile.getMovedFile(), true, true, true, clFile.getDepotFile());
                continue;
            }
            if (clFile.isMoveDeleteAction()) {
                this.model.addElement((Object)clFile, clFile.getIcon(), clFile.getDepotFileNoRevisionNo(), true, true, false, clFile.getDepotFile());
                continue;
            }
            this.model.addElement((Object)clFile, clFile.getIcon(), true, true, clFile.getWorkspaceFile(), clFile.getDepotFile());
        }
        return this.model;
    }

    private ComboBoxModel createComboBoxModel(Collection<PerforceConnectionProfile> cons) {
        DefaultComboBoxModel<PerforceConnectionProfile> model = new DefaultComboBoxModel<PerforceConnectionProfile>();
        for (PerforceConnectionProfile con : cons) {
            model.addElement(con);
        }
        return model;
    }

    public PerforceConnectionProfile getSelectedConnection() {
        return (PerforceConnectionProfile)this.chbConnection.getSelectedItem();
    }

    private void addListener() {
        this.chbConnection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ChangeListPanel.this.removeAllCheckBoxListModel();
                    ChangeListPanel.this.defaultCLFiles.clear();
                    ChangeListPanel.this.filesOnDefaultCL();
                }
                catch (Exception f) {
                    sLogger.warning(f.getMessage());
                }
            }
        });
    }

    private void filesOnDefaultChangeList(PerforceConnectionProfile connect) throws Exception {
        PerforceShellRunner runner = new PerforceShellRunner();
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.add("opened");
        cmds.add("-c");
        cmds.add("default");
        runner.setCmdList(cmds);
        runner.setConnection(connect);
        runner.addOutputMonitor(new ChangelistMonitor());
        runner.setQuiet(false);
        try {
            runner.exec();
            if (runner.getExitCode() == null || runner.getExitCode() != 0) {
                sLogger.log(Level.WARNING, " Failed to get files on default change list " + runner.getErrorText());
                throw new PerforceOperationException(runner.getErrorText());
            }
        }
        catch (Exception ex) {
            sLogger.log(Level.WARNING, " Failed to get files on default change list " + ex.getMessage());
            throw new PerforceProcessException(PerforceArb.get("ERROR_TITLE"), PerforceArb.get("ERROR_FILES_DEFAULT_CHANGE_LIST"), ex.getMessage());
        }
    }

    public void setConnectionProfile(PerforceConnectionProfile connect) {
        this.chbConnection.setSelectedItem(connect);
    }

    private class ChangelistMonitor
    extends VCSStreamMonitor {
        private ChangelistMonitor() {
        }

        protected void streamLine(String line, RunProcess process) throws Exception {
            String[] sections = line.split(" - ");
            if (sections.length >= 2) {
                ChangeListFile clFile = new ChangeListFile();
                clFile.setDepotFile(sections[0]);
                String[] actions = sections[1].split(" ");
                clFile.setAction(actions[0]);
                ChangeListPanel.this.defaultCLFiles.add(clFile);
            }
        }
    }
}

