/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2.requirement;

import java.net.URL;
import oracle.ide.Context;
import oracle.ide.controller.Controller;
import oracle.ide.model.Locatable;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.vcs.generic.ActionRequirement;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionManager;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceSessionManager;
import oracle.jdevimpl.vcs.perforce2.requirement.ApplicationRequirement;
import oracle.jdevimpl.vcs.perforce2.requirement.Connected;
import oracle.jdevimpl.vcs.perforce2.requirement.ProjectRequirement;

public class ProjectOrApplicationNotInPerforce
implements ActionRequirement {
    private ApplicationRequirement appRequire = new ApplicationRequirement();
    private ProjectRequirement prjRequire = new ProjectRequirement();
    private Connected connected = new Connected();

    public boolean isSatisfied(VCSProfile profile, Context context, Controller controller) {
        if (!this.connected.isSatisfied(profile, context, controller)) {
            return false;
        }
        if (this.appRequire.isSatisfied(profile, context, controller) || this.prjRequire.isSatisfied(profile, context, controller)) {
            URL url = ((Locatable)context.getElement()).getURL();
            PerforceConnectionProfile connect = PerforceConnectionManager.getInstance().getConnectionProfile(url);
            if (connect == null) {
                return false;
            }
            return !URLFileSystem.isBaseURLFor((URL)PerforceSessionManager.getInstance().getClientRootFolder(connect), (URL)url);
        }
        return false;
    }
}

