/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2.prefs;

import java.awt.Component;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.SwingWorker;
import oracle.ide.Ide;
import oracle.ide.panels.TraversalException;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.vcs.controls.VCSCommandLinePanel;
import oracle.jdeveloper.vcs.migrate.VCSShellRunner;
import oracle.jdeveloper.vcs.spi.VCSPreferencesTraversable;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdeveloper.vcs.util.VCSOperatingSystem;
import oracle.jdevimpl.vcs.perforce2.prefs.PerforceSystemPreferences;
import oracle.jdevimpl.vcs.perforce2.res.PerforceArb;

public class PerforceSystemTraversable
extends VCSPreferencesTraversable<PerforceSystemPreferences> {
    private UI _ui = null;
    private static URL[] _locations;

    protected PerforceSystemPreferences getPreferences(PropertyStorage prefs) {
        return PerforceSystemPreferences.getInstance(prefs);
    }

    protected Component getPage() {
        if (this._ui == null) {
            _locations = VCSFileSystemUtils.searchSystemPathFully((String)"p4");
            this._ui = new UI();
            RevisionSwingWorker worker = new RevisionSwingWorker(this._ui);
            worker.execute();
        }
        return this._ui;
    }

    protected void validatePreferences() throws TraversalException {
        if (((UI)((Object)this.getPage())).getPathRadio() == "OtherPath") {
            String path = ((UI)((Object)this.getPage())).getPathLocation();
            if (path.equals("")) {
                throw new TraversalException(PerforceArb.get("PREFERENCE_PATH_EMPTY"));
            }
            File exePath = new File(path);
            if (!exePath.isAbsolute() || exePath.isDirectory()) {
                throw new TraversalException(PerforceArb.get("PREFERENCE_PATH_EMPTY"));
            }
        }
    }

    protected void savePreferences(PerforceSystemPreferences prefs) {
        prefs.setPerforceCommandLocation(((UI)((Object)this.getPage())).getPathLocation());
        prefs.setPerforceRadioCommand(((UI)((Object)this.getPage())).getPathRadio());
    }

    protected void loadPreferences(PerforceSystemPreferences prefs) {
        ((UI)((Object)this.getPage())).setPathRadio(prefs.getPerforceRadioCommand());
        ((UI)((Object)this.getPage())).setPathLocation(prefs.getPerforceCommandLocation());
    }

    private static final class RevisionSwingWorker
    extends SwingWorker<String[], String> {
        private UI _ui;

        RevisionSwingWorker(UI ui) {
            this._ui = ui;
        }

        @Override
        protected String[] doInBackground() {
            String[] revisions = this.getRevisionNumbers(_locations);
            return revisions;
        }

        @Override
        protected void done() {
            try {
                String[] revisions = (String[])this.get();
                HashMap<String, String> cmdRevisions = new HashMap<String, String>();
                for (int l = 0; l < _locations.length; ++l) {
                    cmdRevisions.put(_locations[l].getPath(), revisions[l]);
                }
                this._ui.setCommandRevisions(cmdRevisions);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private String[] getRevisionNumbers(URL[] urls) {
            String[] revisions = new String[urls.length];
            VCSShellRunner runner = new VCSShellRunner();
            for (int u = 0; u < urls.length; ++u) {
                ArrayList<String> cmds = new ArrayList<String>();
                cmds.add(urls[u].getPath());
                cmds.add("-V");
                runner.setCmdList(cmds);
                runner.getSimpleProcess().setUseLogPage(false);
                runner.getSimpleProcess().setShowStartStatus(false);
                runner.getSimpleProcess().setAddToProcessesFolder(false);
                try {
                    runner.execAndWait();
                }
                catch (Exception e) {
                    revisions[u] = PerforceArb.get("PREFERNECE_NO_REVISION");
                    this.publish(revisions[u]);
                    continue;
                }
                String[] output = runner.getOutputText().split("\n");
                if (output.length != 7) continue;
                String[] revs = output[6].split(" ");
                revisions[u] = revs[1].trim();
                this.publish(revisions[u]);
            }
            return revisions;
        }
    }

    private static final class UI
    extends VCSCommandLinePanel {
        private UI() {
        }

        protected String getIdentifyLabel() {
            return PerforceArb.format("PREFERENCE_IDENTIFY", Ide.getProgramShortName());
        }

        protected String getDefaultClient() {
            return VCSOperatingSystem.isWindows() ? "p4.exe" : "p4";
        }

        protected URL[] getCommandLocations() {
            return _locations;
        }
    }
}

