/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2.nav.cmd;

import java.net.URL;
import java.util.ArrayList;
import oracle.ide.Context;
import oracle.ide.ProductInformation;
import oracle.ide.model.Locatable;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.jdeveloper.vcs.generic.CommandState;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.spi.VCSDirectoryInvokable;
import oracle.jdeveloper.vcs.spi.VCSDirectoryInvokableState;
import oracle.jdeveloper.vcs.util.VCSContextUtils;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdevimpl.vcs.generic.util.VCSDirectoryWatcher;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceFileAndDirectoryInvokable;
import oracle.jdevimpl.vcs.perforce2.PerforceSessionManager;
import oracle.jdevimpl.vcs.perforce2.PerforceShellRunner;
import oracle.jdevimpl.vcs.perforce2.cmd.PerforceExtendedSync;
import oracle.jdevimpl.vcs.perforce2.error.PerforceProcessException;
import oracle.jdevimpl.vcs.perforce2.nav.RemoteItem;
import oracle.jdevimpl.vcs.perforce2.res.PerforceArb;
import oracle.jdevimpl.vcs.perforce2.util.PerforceUtil;

public class PerforceSyncDepotCommand
extends PerforceExtendedSync {
    public static final String COMMAND_ID = "oracle.jdeveloper.perforce2.syncDepot";

    public PerforceSyncDepotCommand() {
        super(COMMAND_ID);
    }

    protected int doitImpl(VCSProfile profile) throws Exception {
        Locatable[] locatables = VCSContextUtils.getContextLocatables((Context)this.getContext(), (URLFilter)profile.getURLFilter("oracle.jdeveloper.perforce.filters.url.REMOTE"));
        if (locatables == null || locatables.length == 0) {
            return 9;
        }
        CommandState commandState = this.getCommandState(profile, locatables);
        if (commandState == null) {
            return 9;
        }
        URL serverURL = locatables[0].getURL();
        PerforceConnectionProfile connect = this.getConnectionProfile(this.getContext());
        URL clientDestinationURL = PerforceSessionManager.getInstance().getClientURL(connect, serverURL);
        VCSDirectoryWatcher watcher = new VCSDirectoryWatcher(clientDestinationURL);
        watcher.beginWatch();
        boolean success = this.invokeCommand(profile, commandState);
        if (success) {
            watcher.endWatch();
            this.postSyncInvoke(profile, connect, watcher, serverURL);
        }
        return success ? 0 : 1;
    }

    protected CommandState getCommandState(VCSProfile profile, Locatable[] locatables) throws Exception {
        VCSDirectoryInvokableState invokableState = new VCSDirectoryInvokableState(VCSModelUtils.convertNodesToURLs((Locatable[])locatables));
        CommandState commandState = new CommandState();
        commandState.setInvokableState(invokableState);
        commandState.setLocatables(locatables);
        return commandState;
    }

    protected VCSDirectoryInvokable syncItems(final PerforceConnectionProfile connect, final CommandState commandState, final PerforceShellRunner runner, final String spec) {
        return new PerforceFileAndDirectoryInvokable(commandState.getInvokableState(), 10){

            @Override
            protected boolean doInvocation2(URL parent, URL[] invokeUrls) throws Exception {
                ArrayList<String> paths = new ArrayList<String>(invokeUrls.length);
                for (URL url : invokeUrls) {
                    StringBuilder path = new StringBuilder(URLFileSystem.getPath((URL)url));
                    path.append(spec == null ? "" : spec);
                    path.append(PerforceSyncDepotCommand.this.isDirectory(commandState, url) ? "/..." : "");
                    paths.add(path.toString());
                }
                runner.setFiles(paths);
                PerforceSyncDepotCommand.this.doInvocationImpl(connect, runner);
                return true;
            }
        };
    }

    private boolean isDirectory(CommandState commandState, URL url) {
        Locatable[] locatables;
        for (Locatable locatable : locatables = commandState.getLocatables()) {
            if (!locatable.getURL().equals(url) || !(locatable instanceof RemoteItem)) continue;
            return ((RemoteItem)locatable).isDirectory();
        }
        return false;
    }

    private void doInvocationImpl(PerforceConnectionProfile connect, PerforceShellRunner runner) throws Exception {
        runner.exec();
        if (runner.getExitCode() == null || runner.getExitCode() != 0) {
            PerforceUtil.isErrorConnection(runner, connect, PerforceArb.get("ERROR_SYNC_FAILED_TITLE"));
            throw new PerforceProcessException(PerforceArb.get("ERROR_SYNC_DEPOT_TITLE"), PerforceArb.format("ERROR_SYNC_DEPOT_FAILED", ProductInformation.getProductInformation().getShortName()), runner.getErrorText());
        }
    }

    private PerforceConnectionProfile getConnectionProfile(Context context) {
        return (PerforceConnectionProfile)context.getElement().getData();
    }
}

