/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2.nav;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import oracle.ide.Ide;
import oracle.ide.model.DefaultContainer;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.runner.RunProcess;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.vcs.migrate.VCSStreamMonitor;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceShellRunner;
import oracle.jdevimpl.vcs.perforce2.error.PerforceProcessException;
import oracle.jdevimpl.vcs.perforce2.nav.PerforceNavURLFileSystemHelper;
import oracle.jdevimpl.vcs.perforce2.nav.PerforceRemoteFile;
import oracle.jdevimpl.vcs.perforce2.nav.RemoteItem;
import oracle.jdevimpl.vcs.perforce2.nav.cmd.PerforceFilterByWorkspace;
import oracle.jdevimpl.vcs.perforce2.res.PerforceArb;
import oracle.jdevimpl.vcs.perforce2.util.PerforceUtil;

public class PerforceRemoteFolder
extends DefaultContainer
implements RemoteItem {
    private PerforceConnectionProfile _con;
    private String _label;
    private static final Logger sLogger = PerforceProfile.getQualifiedLogger(PerforceShellRunner.class.getName());

    public PerforceRemoteFolder(PerforceConnectionProfile con) {
        this._con = con;
    }

    public Icon getIcon() {
        return OracleIcons.getIcon((String)"folder.png");
    }

    public String getLongLabel() {
        return this.getShortLabel();
    }

    public String getShortLabel() {
        if (this._label == null && this.getURL() != null) {
            this._label = URLFileSystem.getFileName((URL)this.getURL());
        }
        return this._label;
    }

    public boolean mayHaveChildren() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void openImpl() throws IOException {
        ArrayList arrayList = this._children;
        synchronized (arrayList) {
            this._children.clear();
            try {
                this._children.addAll(this.list(this._con, this.isFilterByWorkspace()));
            }
            catch (PerforceProcessException e) {
                PerforceProfile.getErrorHandler().handleException((Exception)((Object)e));
            }
        }
    }

    public Object getData() {
        return this._con;
    }

    protected Collection list(PerforceConnectionProfile connect, boolean filter) throws IOException, PerforceProcessException {
        PerforceShellRunner runner = new PerforceShellRunner();
        StringBuilder sb = new StringBuilder();
        ArrayList<String> cmds = new ArrayList<String>();
        ArrayList kids = new ArrayList();
        String host = connect.getHostName();
        Integer port = connect.getPortNumber();
        URL url = this.getURL();
        if (url == null) {
            return Collections.EMPTY_LIST;
        }
        NavigatorDirMonitor dirMonitor = new NavigatorDirMonitor(host, (int)port);
        NavigatorFileMonitor fileMonitor = new NavigatorFileMonitor(host, (int)port);
        sb.append('\"');
        sb.append(URLFileSystem.getPath((URL)this.getURL()));
        sb.append("*");
        sb.append('\"');
        cmds.add("dirs");
        if (filter) {
            cmds.add("-C");
        }
        cmds.add(sb.toString());
        runner.setConnection(connect);
        runner.setCmdList(cmds);
        runner.setQuiet(true);
        runner.addOutputMonitor(dirMonitor);
        try {
            runner.exec();
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, e.getMessage());
            throw new IOException(e.getMessage());
        }
        if (runner.getExitCode() == null || runner.getExitCode() != 0) {
            PerforceUtil.isErrorConnection(runner, connect, PerforceArb.get("PERFORCE_CONNECTION_TITLE"));
            sLogger.log(Level.WARNING, PerforceArb.format("ERROR_DIR_CHILDREN_OF", this.getShortLabel()));
            return Collections.emptyList();
        }
        kids.addAll(dirMonitor.getItems());
        cmds.clear();
        cmds.add("files");
        cmds.add(sb.toString());
        runner.setCmdList(cmds);
        runner.addOutputMonitor(fileMonitor);
        try {
            runner.exec();
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        if (runner.getExitCode() == null || runner.getExitCode() != 0) {
            PerforceUtil.isErrorConnection(runner, connect, PerforceArb.get("PERFORCE_CONNECTION_TITLE"));
            sLogger.log(Level.WARNING, PerforceArb.format("ERROR_FILE_CHILDREN_OF", this.getShortLabel()));
            return Collections.emptyList();
        }
        kids.addAll(fileMonitor.getItems());
        return kids;
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    @Override
    public PerforceConnectionProfile getConnectionProfile() {
        return this._con;
    }

    private boolean isFilterByWorkspace() {
        Boolean filter = Ide.getDTCache().getBoolean("Perforce.filter.workspace." + this._con.toString(), PerforceFilterByWorkspace.FILTER_DEFAULT.booleanValue());
        return filter;
    }

    private class NavigatorFileMonitor
    extends NavigatorMonitor {
        private NavigatorFileMonitor(String host, Integer port) {
            super(host, port);
        }

        protected void streamLine(String line, RunProcess process) throws Exception {
            if (line.contains("- delete change")) {
                return;
            }
            String[] path = line.split("#");
            PerforceRemoteFile file = new PerforceRemoteFile(PerforceRemoteFolder.this);
            String[] parts = path[1].split(" ");
            file.setRevision(parts[0]);
            if (parts.length >= 45) {
                file.setChangeNo(parts[4]);
            }
            file.setURL(((NavigatorMonitor)this).getURL(path[0]));
            this._items.add(file);
        }
    }

    private class NavigatorDirMonitor
    extends NavigatorMonitor {
        private NavigatorDirMonitor(String host, Integer port) {
            super(host, port);
        }

        protected void streamLine(String line, RunProcess process) throws Exception {
            PerforceRemoteFolder folder = new PerforceRemoteFolder(PerforceRemoteFolder.this._con);
            String path = line + '/';
            folder.setURL(((NavigatorMonitor)this).getURL(path));
            this._items.add(folder);
        }
    }

    private class NavigatorMonitor
    extends VCSStreamMonitor {
        protected Collection _items = new ArrayList();
        private String _host;
        private Integer _port;

        private NavigatorMonitor(String host, Integer port) {
            this._host = host;
            this._port = port;
        }

        public Collection getItems() {
            return this._items;
        }

        private URL getURL(String path) {
            URL url = URLFactory.newURL((String)PerforceNavURLFileSystemHelper.PERFORCE_NAV_PROTOCOL, null, (String)this._host, (int)this._port, (String)this.convertFromAscii(path), null, null);
            return url;
        }

        private String convertFromAscii(String path) {
            path = path.replace("%40", "@");
            path = path.replace("%23", "#");
            path = path.replace("%2A", "*");
            path = path.replace("%25", "%");
            return path;
        }
    }
}

