/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2.nav;

import java.awt.Component;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controls.ToggleAction;
import oracle.ide.model.Node;
import oracle.jdevimpl.vcs.perforce2.nav.PerforceConnectionNode;
import oracle.jdevimpl.vcs.perforce2.nav.PerforceRemoteFolder;
import oracle.jdevimpl.vcs.perforce2.nav.PerforceRootNode;
import oracle.jdevimpl.vcs.perforce2.nav.RemoteItem;
import oracle.jdevimpl.vcs.perforce2.nav.cmd.PerforceFilterByWorkspace;

public class PerforceNavigatorContextMenu
implements ContextMenuListener {
    public void menuWillShow(ContextMenu popup) {
        Context context = popup.getContext();
        Node node = context.getNode();
        if (node instanceof RemoteItem) {
            this.addMenuItem(popup, Ide.findCmdID((String)"oracle.jdeveloper.perforce2.syncDepot"), MenuConstants.WEIGHT_EDIT_PROPERTIES);
        }
        if (node instanceof PerforceConnectionNode) {
            IdeAction action = IdeAction.find((int)Ide.findCmdID((String)PerforceFilterByWorkspace.COMMAND_ID));
            Boolean filter = Ide.getDTCache().getBoolean("Perforce.filter.workspace." + node.getLongLabel(), PerforceFilterByWorkspace.FILTER_DEFAULT.booleanValue());
            action.setState(filter.booleanValue());
            this.addMenuItem(popup, (ToggleAction)action, MenuConstants.WEIGHT_EDIT_PROPERTIES);
            this.addMenuItem(popup, Ide.findCmdID((String)"oracle.jdeveloper.perforce2.login"), MenuConstants.WEIGHT_EDIT_PROPERTIES + 0.5f);
            this.addMenuItem(popup, Ide.findCmdID((String)"oracle.jdeveloper.perforce2.logout"), MenuConstants.WEIGHT_EDIT_PROPERTIES + 0.5f);
            this.addMenuItem(popup, 56, MenuConstants.WEIGHT_EDIT_PROPERTIES + 1.0f);
            this.addMenuItemRefresh(popup);
        }
        if (node instanceof PerforceRemoteFolder) {
            this.addMenuItemRefresh(popup);
        }
        if (node instanceof PerforceRootNode) {
            this.addMenuItem(popup, Ide.findCmdID((String)"oracle.jdeveloper.perforce.newconnection"), 1.0f);
            this.addMenuItem(popup, Ide.findCmdID((String)"oracle.jdeveloper.perforce2.export-connections"), 2.0f);
            this.addMenuItem(popup, Ide.findCmdID((String)"oracle.jdeveloper.perforce2.import-connections"), 2.0f);
        }
    }

    public void menuWillHide(ContextMenu popup) {
    }

    public boolean handleDefaultAction(Context ctx) {
        return false;
    }

    protected final void addMenuItemRefresh(ContextMenu popup) {
        if (popup.getIndexOfCommandId(popup.getGUI(true), 51) >= 0) {
            return;
        }
        popup.add((Component)popup.createMenuItem((ToggleAction)IdeAction.find((int)51)), MenuConstants.WEIGHT_EDIT_PROPERTIES + 1.0f);
    }

    private void addMenuItem(ContextMenu popup, int commandId, float weight) {
        popup.add((Component)popup.createMenuItem((ToggleAction)IdeAction.find((int)commandId)), weight);
    }

    private void addMenuItem(ContextMenu popup, ToggleAction action, float weight) {
        popup.add((Component)popup.createMenuItem(action, weight));
    }
}

