/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2.nav;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.model.Node;
import oracle.ide.util.Assert;
import oracle.jdeveloper.vcs.nav.VersioningNavigatorConstants;
import oracle.jdevimpl.vcs.perforce2.PerforceProfile;
import oracle.jdevimpl.vcs.perforce2.nav.PerforceNavigatorController;
import oracle.jdevimpl.vcs.perforce2.nav.PerforceRemoteFolder;
import oracle.jdevimpl.vcs.perforce2.nav.cmd.PerforceEditConnectionCommand;

public class PerforceDepotNavigatorAPI {
    private static final Logger sLogger = PerforceProfile.getQualifiedLogger(PerforceDepotNavigatorAPI.class.getName());
    private static final PerforceDepotNavigatorAPI _sInstance = new PerforceDepotNavigatorAPI();
    private PerforceNavigatorController _controller;

    private PerforceDepotNavigatorAPI() {
    }

    public static PerforceDepotNavigatorAPI getInstance() {
        return _sInstance;
    }

    public void activate() {
        this._controller = new PerforceNavigatorController();
        IdeAction[] actions = this.getIdeActions();
        for (int i = 0; i < actions.length; ++i) {
            actions[i].addController((Controller)this._controller);
        }
    }

    public void showRepositoryNavigator() {
        Runnable runme = new Runnable(){

            @Override
            public void run() {
                IdeAction showNavigatorAction = IdeAction.find((int)VersioningNavigatorConstants.SHOW_NAVIGATOR_CMD_ID);
                try {
                    if (showNavigatorAction != null) {
                        showNavigatorAction.performAction();
                    }
                }
                catch (Exception e) {
                    Assert.printStackTrace((Throwable)e);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runme.run();
        } else {
            SwingUtilities.invokeLater(runme);
        }
    }

    private IdeAction[] getIdeActions() {
        int[] actionIds = new int[]{20, 51, 56, Ide.findCmdID((String)"oracle.jdeveloper.perforce2.syncDepot"), Ide.findCmdID((String)"oracle.jdeveloper.perforce.newconnection")};
        ArrayList<IdeAction> actions = new ArrayList<IdeAction>(10);
        for (int i = 0; i < actionIds.length; ++i) {
            IdeAction action = IdeAction.find((int)actionIds[i]);
            if (action == null) continue;
            actions.add(action);
        }
        return actions.toArray(new IdeAction[actions.size()]);
    }

    boolean canRefresh(Node node) {
        return node instanceof PerforceRemoteFolder && node.isOpen();
    }

    boolean connect(Context context) {
        PerforceEditConnectionCommand command = new PerforceEditConnectionCommand();
        try {
            command.setContext(context);
            if (CommandProcessor.getInstance().invoke((Command)command) == 0) {
                return true;
            }
        }
        catch (Exception e) {
            PerforceProfile.getErrorHandler().handleException(e);
            sLogger.log(Level.WARNING, "Error " + e.getMessage());
        }
        return false;
    }
}

