/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2.nav;

import java.awt.Component;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.DialogHeader;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.jdeveloper.vcs.nav.ConnectionListFilterNode;
import oracle.jdeveloper.vcs.nav.ConnectionProvider;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionManager;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceImportExportWizard;
import oracle.jdevimpl.vcs.perforce2.PerforceSessionManager;
import oracle.jdevimpl.vcs.perforce2.nav.PerforceConnectionNode;
import oracle.jdevimpl.vcs.perforce2.nav.PerforceConnectionWizard;
import oracle.jdevimpl.vcs.perforce2.nav.PerforceDepotFilterNode;
import oracle.jdevimpl.vcs.perforce2.nav.PerforceDepotNavigatorAPI;
import oracle.jdevimpl.vcs.perforce2.nav.PerforceDepotNavigatorManager;
import oracle.jdevimpl.vcs.perforce2.res.PerforceArb;
import oracle.jdevimpl.vcs.perforce2.ui.ImportOrCreateConnectionPanel;

public class PerforceDepotConnectionProvider
extends ConnectionProvider {
    public Node getConnectionListNode() {
        PerforceDepotNavigatorAPI.getInstance().activate();
        return PerforceDepotNavigatorManager.getInstance().getRootNode();
    }

    public String getALMTeamSourceControlType() {
        return "Perforce";
    }

    public Element createConnectionListNode(Collection<Map<String, String>> criteria, boolean createConnections) {
        PerforceDepotFilterNode root = new PerforceDepotFilterNode();
        Collection<PerforceConnectionProfile> connects = this.getConnections();
        for (Map<String, String> map : criteria) {
            String s = map.get("server");
            if (s == null) continue;
            StringBuilder sb = new StringBuilder(s);
            sb.append(":");
            sb.append(map.get("port"));
            String server = sb.toString();
            PerforceConnectionProfile con = this.findConnection(connects, server);
            if (con == null) {
                con = new PerforceConnectionProfile();
                con.setServer(server);
            }
            PerforceConnectionNode node = new PerforceConnectionNode(con);
            PerforceSessionManager.getInstance().addConnectionListeners(node);
            root.addConnectionNode((Element)node);
        }
        return root;
    }

    private final Collection<PerforceConnectionProfile> getConnections() {
        List connects;
        try {
            connects = PerforceConnectionManager.getInstance().list();
        }
        catch (Exception e) {
            connects = Collections.EMPTY_LIST;
        }
        return connects;
    }

    protected ConnectionListFilterNode createConnectionListFilterNode() {
        return new PerforceDepotFilterNode();
    }

    protected String[] getConnectionCriteriaKeys() {
        return new String[]{"server", "port"};
    }

    private PerforceConnectionProfile findConnection(Collection<PerforceConnectionProfile> connects, String server) {
        for (PerforceConnectionProfile con : connects) {
            if (!con.getServer().equals(server)) continue;
            return con;
        }
        return null;
    }

    public boolean isConnected() {
        return !this.getConnections().isEmpty();
    }

    public void runConnect(Context context) {
        ImportOrCreateConnectionPanel panel = new ImportOrCreateConnectionPanel();
        JEWTDialog dialog = OnePageWizardDialogFactory.createJEWTDialog((Component)VCSWindowUtils.getCurrentWindow(), (Component)((Object)panel), (Component)((Object)panel), (String)PerforceArb.get("IMPORT_OR_CREATE_TITLE"), (int)3);
        DialogHeader header = new DialogHeader();
        header.setHeaderDescription(PerforceArb.get("IMPORT_OR_CREATE_HEADER"));
        dialog.setDialogHeader((Component)header);
        WizardLauncher.runDialog((JDialog)dialog);
        if (dialog.isCancelled()) {
            return;
        }
        if (panel.isManualCreationSelected()) {
            new PerforceConnectionWizard().invoke(context);
        } else {
            new PerforceImportExportWizard().invokeImportWizard(context, new String[0]);
        }
    }
}

