/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2.migration;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import oracle.ide.migration.ExtensionMigrator;
import oracle.jdeveloper.vcs.migrate.VCSPropertyMapMigrator;
import oracle.jdeveloper.vcs.spi.VCSPropertyMap;
import oracle.jdevimpl.vcs.perforce2.PerforceProfile;
import oracle.jdevimpl.vcs.perforce2.prefs.PerforceVersionToolsPreferences;

public class PerforceExtensionMigrator
extends VCSPropertyMapMigrator {
    static final String JDEVELOPER_EXTENSION_DIRECTORY_RE = "oracle.jdeveloper.[\\.\\d]+";
    private static final String SYSTEM_OPTIONS_DATA_KEY = PerforceProfile.getQualifiedKey("oracle.jdeveloper.vcs.data.COMMON_SETTINGS");
    private static final String VERSION_TOOLS_DATA_KEY = PerforceProfile.getQualifiedKey("perforcevcs_version_tools_properties");
    private static final String COMMENT_TEMPLATES_DATA_KEY = PerforceProfile.getQualifiedKey("COMMENT_TEMPLATES");
    private static final String KEY_CHANGE_LIST_CID = "changelist_cid";
    private static final String KEY_CLIENT_MERGE = "perforcevcs_clientMerge";

    protected List getSettingKeys() {
        Object[] keys = new Object[]{SYSTEM_OPTIONS_DATA_KEY, VERSION_TOOLS_DATA_KEY, COMMENT_TEMPLATES_DATA_KEY};
        return Arrays.asList(keys);
    }

    protected String getExtensionID() {
        return "oracle.jdeveloper.perforce";
    }

    protected ExtensionMigrator.AdjustedObject[] adjustPropertyMap(String inKey, VCSPropertyMap properties) {
        Map propertyMap = properties.getMap();
        if (inKey.equals(SYSTEM_OPTIONS_DATA_KEY)) {
            return this.createAdjustedCustomizerObject(properties);
        }
        if (inKey.equals(VERSION_TOOLS_DATA_KEY)) {
            PerforceVersionToolsPreferences prefs = PerforceVersionToolsPreferences.getInstance(null);
            if (propertyMap.containsKey(KEY_CLIENT_MERGE)) {
                prefs.setUseClientMerge((Boolean)propertyMap.get(KEY_CLIENT_MERGE));
            }
            if (propertyMap.containsKey(KEY_CHANGE_LIST_CID)) {
                String VALUE_CID_COMMENTS = "changelist_cid_comments";
                String VALUE_CID_NEVER = "changelist_cid_never";
                String VALUE_CID_ALWAYS = "changelist_cid_always";
                if (propertyMap.get(KEY_CHANGE_LIST_CID).equals(VALUE_CID_COMMENTS)) {
                    prefs.setPendingChangesDialogUsage(1);
                } else if (propertyMap.get(KEY_CHANGE_LIST_CID).equals(VALUE_CID_NEVER)) {
                    prefs.setPendingChangesDialogUsage(2);
                } else if (propertyMap.get(KEY_CHANGE_LIST_CID).equals(VALUE_CID_ALWAYS)) {
                    prefs.setPendingChangesDialogUsage(0);
                }
            }
            return new ExtensionMigrator.AdjustedObject[]{new ExtensionMigrator.AdjustedObject("oracle.jdevimpl.vcs.perforce2.prefs.PerforceVersionToolsPreferences", (Object)prefs)};
        }
        if (inKey.equals(COMMENT_TEMPLATES_DATA_KEY)) {
            return this.createAdjustedCommentTemplatesObject(properties);
        }
        return new ExtensionMigrator.AdjustedObject[0];
    }
}

