/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2.history;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Date;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.history.RevisionIdentifier;
import oracle.jdeveloper.vcs.generic.VCSHistoryEntry;
import oracle.jdeveloper.vcs.generic.VCSProfileRegistry;
import oracle.jdeveloper.vcs.spi.VCSException;
import oracle.jdevimpl.vcs.perforce2.history.PerforceContent;
import oracle.jdevimpl.vcs.perforce2.res.PerforceArb;

public class PerforceHistoryEntry
extends VCSHistoryEntry {
    private static final String HISTORY_PROP_AUTHOR_ID = "oracle.jdeveloper.perforce2.history.AUTHOR";
    public static final String HISTORY_PROP_CHANGELIST_ID = "oracle.jdeveloper.perforce2.history.CHANGELIST";
    private static final String HISTORY_PROP_ACTION_ID = "oracle.jdeveloper.perforce2.history.ACTION";
    private URL _url;
    private RevisionIdentifier _revisionNumber;

    public PerforceHistoryEntry(URL url, RevisionIdentifier revision, Date date, String changelist, String action, String user, String client, String description) {
        super(url, VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.perforce"));
        this.setValue("oracle.jdeveloper.vcs.history.DATE", date);
        this.setValue("oracle.jdeveloper.vcs.history.REVISION", revision);
        this.setValue(HISTORY_PROP_AUTHOR_ID, user);
        this.setValue("oracle.jdeveloper.vcs.history.DESCRIPTION", description);
        this.setValue(HISTORY_PROP_CHANGELIST_ID, changelist);
        this.setValue(HISTORY_PROP_ACTION_ID, action);
        this._url = url;
        this._revisionNumber = revision;
    }

    protected InputStream getContent(URL url, RevisionIdentifier rev) throws IOException, VCSException {
        PerforceContent content = new PerforceContent();
        byte[] versionContents = content.getVersionContent(this._url, this._revisionNumber.getLabel());
        return new ByteArrayInputStream(versionContents);
    }

    protected String getResourceName(URL url, RevisionIdentifier rev) {
        return MessageFormat.format(PerforceArb.get("COMPARE_CONTRIBUTOR_NAME"), rev.getLabel(), URLFileSystem.getName((URL)url));
    }
}

