/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2.connection;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import oracle.ide.ExtensionRegistry;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceProfile;
import oracle.jdevimpl.vcs.perforce2.connection.io.ObjectFactory;
import oracle.jdevimpl.vcs.perforce2.connection.io.PerforceConnectionType;
import oracle.jdevimpl.vcs.perforce2.connection.io.PerforceConnectionsType;

public class PerforceConnectionHelper {
    private static final Logger sLogger = PerforceProfile.getQualifiedLogger(PerforceConnectionHelper.class.getName());
    public static final String FILENAME = "perforceconnections.xml";
    private URL _storeURL;
    private JAXBContext _ioContext;
    private Collection<PerforceConnectionProfile> _index;
    private final Lock _lock = new ReentrantLock();

    public PerforceConnectionHelper() {
        URL url = ExtensionRegistry.getExtensionRegistry().getSystemDirectory("oracle.jdeveloper.perforce");
        this._storeURL = URLFactory.newURL((URL)url, (String)FILENAME);
        this._index = new ArrayList<PerforceConnectionProfile>();
        try {
            this._ioContext = JAXBContext.newInstance((String)"oracle.jdevimpl.vcs.perforce2.connection.io", (ClassLoader)ExtensionRegistry.getExtensionRegistry().getClassLoader("oracle.jdeveloper.perforce"));
        }
        catch (JAXBException je) {
            sLogger.log(Level.WARNING, "unable to obtain binding context for Perforce-connections.xml", je);
        }
    }

    public Collection<PerforceConnectionProfile> getPersistedProfiles() {
        this.load();
        return this._index;
    }

    public void setPersistedProfiles(Collection<PerforceConnectionProfile> list) {
        this._index.clear();
        this._index.addAll(list);
        if (list.isEmpty()) {
            URLFileSystem.delete((URL)this.getStoreURL());
        } else {
            this.save();
        }
    }

    public boolean hasConnection() {
        return URLFileSystem.exists((URL)this.getStoreURL());
    }

    protected URL getStoreURL() {
        return this._storeURL;
    }

    private void save() {
        if (this._ioContext == null) {
            sLogger.log(Level.WARNING, "jaxb context unavailable");
        }
        this._lock.lock();
        try {
            ObjectFactory objectFact = new ObjectFactory();
            this.marshall(this.createIoConnections(objectFact), objectFact);
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "unable to write perforceconnections.xml", e);
        }
        finally {
            this._lock.unlock();
        }
    }

    private void load() {
        if (this._ioContext == null) {
            sLogger.log(Level.WARNING, "jaxb context unavailable");
        }
        this._lock.lock();
        this._index.clear();
        try {
            this.indexIoProfiles(this.unMarshell());
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "unable to load connections", e);
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<PerforceConnectionType> unMarshell() throws JAXBException, IOException {
        if (!URLFileSystem.exists((URL)this.getStoreURL())) {
            return Collections.EMPTY_LIST;
        }
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(URLFileSystem.openInputStream((URL)this.getStoreURL()));
            Unmarshaller ioWorker = this._ioContext.createUnmarshaller();
            JAXBElement jaxBElm = (JAXBElement)ioWorker.unmarshal((InputStream)is);
            PerforceConnectionsType connections = (PerforceConnectionsType)jaxBElm.getValue();
            List<PerforceConnectionType> list = connections.getPerforceConnection();
            return list;
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void marshall(List<PerforceConnectionType> ioList, ObjectFactory fact) throws JAXBException, FileNotFoundException {
        Marshaller ioWorker = this._ioContext.createMarshaller();
        PerforceConnectionsType connections = fact.createPerforceConnectionsType();
        connections.getPerforceConnection().addAll(ioList);
        ioWorker.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        OutputStream os = null;
        try {
            JAXBElement<PerforceConnectionsType> jaxBElm = fact.createPerforceConnections(connections);
            os = new BufferedOutputStream(new FileOutputStream(URLFileSystem.getPlatformPathName((URL)this.getStoreURL()), false));
            ioWorker.marshal(jaxBElm, os);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void indexIoProfiles(List<PerforceConnectionType> Perforce) {
        for (PerforceConnectionType con : Perforce) {
            PerforceConnectionProfile profile = new PerforceConnectionProfile();
            profile.setName(con.getName());
            profile.setClient(con.getClient());
            profile.setServer(con.getServer());
            profile.setUser(con.getUser());
            this._index.add(profile);
        }
    }

    private List<PerforceConnectionType> createIoConnections(ObjectFactory objectFact) {
        if (this._index.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<PerforceConnectionType> io = new ArrayList<PerforceConnectionType>(this._index.size());
        for (PerforceConnectionProfile profile : this._index) {
            PerforceConnectionType dt = objectFact.createPerforceConnectionType();
            dt.setName(profile.getName());
            dt.setUser(profile.getUser());
            dt.setServer(profile.getServer());
            dt.setClient(profile.getClient());
            io.add(dt);
        }
        return io;
    }
}

