/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2.cmd.custom;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizer;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceProfile;
import oracle.jdevimpl.vcs.perforce2.cmd.custom.CommonChangeListPanel;
import oracle.jdevimpl.vcs.perforce2.res.PerforceArb;
import oracle.jdevimpl.vcs.perforce2.util.PerforceUtil;

public class PerforceEditCustomizer
implements VCSOptionsCustomizer {
    private static Logger sLogger = PerforceProfile.getQualifiedLogger(PerforceEditCustomizer.class.getName());
    private EditOptionsPanel _panel;
    private PerforceConnectionProfile _connect;

    public PerforceEditCustomizer(PerforceConnectionProfile connect) {
        this._connect = connect;
    }

    public Component getComponent() {
        if (this._panel == null) {
            this._panel = new EditOptionsPanel();
        }
        return this._panel;
    }

    public Component getInitialFocusComponent() {
        return null;
    }

    public void setOptions(Map options) {
        Boolean bs;
        this.getComponent();
        Boolean b = (Boolean)options.get("setting_lock");
        if (b != null) {
            this._panel.getLockBox().setSelected(b);
        }
        if ((bs = (Boolean)options.get("setting_sync")) != null) {
            this._panel.getSyncBox().setSelected(bs);
        }
    }

    public Map getOptions() {
        this.getComponent();
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("setting_lock", this._panel.getLockBox().isSelected());
        m.put("setting_sync", this._panel.getSyncBox().isSelected());
        try {
            String changelist = this._panel.getChangeListNo();
            if (changelist.equals(PerforceUtil.getDefaultChangelist(this._connect))) {
                m.put("open_on_changelist", changelist);
            } else {
                m.put("open_on_changelist", PerforceUtil.getChangelistNo(this._connect, changelist));
            }
        }
        catch (Exception e) {
            sLogger.warning(e.getMessage());
        }
        return m;
    }

    public void validateOptions() {
    }

    private class EditOptionsPanel
    extends CommonChangeListPanel {
        private JCheckBox _lockBox = new JCheckBox();
        private JCheckBox _syncBox = new JCheckBox();

        private EditOptionsPanel() {
            this.jbInit();
        }

        private void jbInit() {
            this.setLayout(new GridBagLayout());
            Insets ins = new Insets(5, 5, 5, 5);
            ResourceUtils.resButton((AbstractButton)this._syncBox, (String)PerforceArb.get("EDIT_CUSTOMIZER_SYNC"));
            ResourceUtils.resButton((AbstractButton)this._lockBox, (String)PerforceArb.get("EDIT_CUSTOMIZER_LOCK"));
            ResourceUtils.resLabel((JLabel)this.lblChangelist, (Component)this.cmbChangelist, (String)PerforceArb.get("EDIT_CUSTOMIZER_CHANGELIST_LABEL"));
            this.add((Component)this.lblChangelist, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, ins, 0, 0));
            this.add((Component)this.cmbChangelist, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, ins, 0, 0));
            this.add((Component)this._syncBox, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 13, 2, ins, 0, 0));
            this.add((Component)this._lockBox, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 13, 2, ins, 0, 0));
        }

        private final JCheckBox getLockBox() {
            return this._lockBox;
        }

        private final JCheckBox getSyncBox() {
            return this._syncBox;
        }

        @Override
        protected PerforceConnectionProfile getConnectionProfile() {
            return PerforceEditCustomizer.this._connect;
        }
    }
}

