/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2.cmd;

import java.awt.Component;
import java.beans.VetoableChangeListener;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Locatable;
import oracle.ide.wizard.Wizard;
import oracle.ide.wizard.WizardManager;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.vcs.generic.CommandState;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.spi.VCSDialogCommitter;
import oracle.jdeveloper.vcs.spi.VCSDirectoryInvokableState;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizer;
import oracle.jdeveloper.vcs.util.VCSBufferUtils;
import oracle.jdeveloper.vcs.util.VCSDialogRunner;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdevimpl.vcs.generic.util.VCSDirectoryWatcher;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionManager;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceSessionManager;
import oracle.jdevimpl.vcs.perforce2.cmd.PerforceExtendedSync;
import oracle.jdevimpl.vcs.perforce2.cmd.PerforceSyncCommand;
import oracle.jdevimpl.vcs.perforce2.cmd.custom.PerforceSyncCustomizer;
import oracle.jdevimpl.vcs.perforce2.nav.PerforceConnectionWizard;
import oracle.jdevimpl.vcs.perforce2.nav.RemoteItem;
import oracle.jdevimpl.vcs.perforce2.res.PerforceArb;
import oracle.jdevimpl.vcs.perforce2.ui.SyncConnectPanel;

public class PerforceSyncAnyConnectCommand
extends PerforceExtendedSync {
    private static String COMMAND_ID = "oracle.jdeveloper.perforce2.syncany";
    private URL serverURL;
    private VCSDirectoryWatcher watcher;
    private PerforceConnectionProfile _connect;

    public PerforceSyncAnyConnectCommand() {
        super(COMMAND_ID);
    }

    protected int doitImpl(final VCSProfile profile) throws Exception {
        Wizard reposWizard;
        if (PerforceConnectionManager.getInstance().list().isEmpty() && (reposWizard = WizardManager.getInstance().getWizard(PerforceConnectionWizard.class)) != null && !reposWizard.invoke(this.context)) {
            return 1;
        }
        PerforceSyncCustomizer customizer = this.createOptionsCustomizer();
        final JEWTDialog dialog = this.createOperationDialog(null, customizer);
        dialog.setMinimumSize(500, 400);
        customizer.addPreviewListener(new PerforceSyncCommand.PreviewRunner(customizer){

            @Override
            protected boolean doOperation(Map options) throws Exception {
                SyncConnectPanel panel = (SyncConnectPanel)dialog.getContent();
                Collection<RemoteItem> items = panel.getDepotFolders();
                CommandState commandState = PerforceSyncAnyConnectCommand.this.createCommandState(items);
                return PerforceSyncAnyConnectCommand.this.invokeCommandImpl(profile, commandState, (Component)dialog, options);
            }
        });
        dialog.addVetoableChangeListener(this.getDialogCommitter(profile, dialog, null, customizer));
        boolean success = VCSDialogRunner.runDialog((JDialog)dialog);
        if (success) {
            this.watcher.endWatch();
            this.postSyncInvoke(profile, this._connect, this.watcher, this.serverURL);
        }
        return success ? 0 : 1;
    }

    @Override
    protected JEWTDialog createOperationDialog(Collection nodes, VCSOptionsCustomizer customizer) {
        int buttons = 7;
        SyncConnectPanel syncPanel = new SyncConnectPanel(customizer);
        JEWTDialog dialog = OnePageWizardDialogFactory.createJEWTDialog((Component)VCSWindowUtils.getCurrentWindow(), (Component)syncPanel, (Component)syncPanel.getInitialFocus(), (String)this.getDialogTitle(), (int)buttons);
        dialog.setResizable(true);
        dialog.setButtonMask(buttons);
        if (this.getHelpTopicId() != null) {
            HelpSystem.getHelpSystem().registerTopic((JComponent)syncPanel, this.getHelpTopicId());
        }
        return dialog;
    }

    protected CommandState getCommandState(VCSProfile profile, Locatable[] locatables) throws Exception {
        VCSDirectoryInvokableState invokableState = new VCSDirectoryInvokableState(VCSModelUtils.convertNodesToURLs((Locatable[])locatables));
        CommandState commandState = new CommandState();
        commandState.setInvokableState(invokableState);
        commandState.setLocatables(locatables);
        return commandState;
    }

    @Override
    protected VetoableChangeListener getDialogCommitter(final VCSProfile profile, final JEWTDialog dialog, CommandState commandState, PerforceSyncCustomizer customizer) {
        return new VCSDialogCommitter(customizer){

            protected boolean doCommitOperation(Map options) throws Exception {
                SyncConnectPanel panel = (SyncConnectPanel)dialog.getContent();
                Collection<RemoteItem> items = panel.getDepotFolders();
                CommandState commandState = PerforceSyncAnyConnectCommand.this.createCommandState(items);
                RemoteItem item = (RemoteItem)commandState.getLocatables()[0];
                PerforceSyncAnyConnectCommand.this._connect = item.getConnectionProfile();
                PerforceSyncAnyConnectCommand.this.serverURL = commandState.getLocatables()[0].getURL();
                URL clientDestinationURL = PerforceSessionManager.getInstance().getClientURL(PerforceSyncAnyConnectCommand.this._connect, PerforceSyncAnyConnectCommand.this.serverURL);
                PerforceSyncAnyConnectCommand.this.watcher = new VCSDirectoryWatcher(clientDestinationURL);
                PerforceSyncAnyConnectCommand.this.watcher.beginWatch();
                return PerforceSyncAnyConnectCommand.this.invokeCommandImpl(profile, commandState, (Component)dialog, options);
            }

            protected boolean validateOptions() {
                SyncConnectPanel panel = (SyncConnectPanel)dialog.getContent();
                PerforceConnectionProfile connect = panel.getPerforceConnection();
                if (!PerforceSessionManager.getInstance().isConnected(connect)) {
                    MessageDialog.information((Component)dialog, (Object)PerforceArb.format("PERFORCE_SYNC_NOT_LOGGED_IN", connect.toString()), (String)PerforceArb.get("PERFORCE_SYNC_NOT_LOGGED_TITLE"), null);
                    return false;
                }
                if (panel.getDepotFolders().isEmpty()) {
                    MessageDialog.information((Component)dialog, (Object)PerforceArb.get("PERFORCE_OPEN_SYNC_FILES"), (String)PerforceArb.get("PERFORCE_SYNC_OPEN_FILES_TITLE"), null);
                    return false;
                }
                return true;
            }
        };
    }

    private CommandState createCommandState(Collection<RemoteItem> items) throws Exception {
        Locatable[] locatables = items.toArray(new Locatable[0]);
        Collection nodesPreCoalesce = this.getFilteredSelection(locatables);
        Collection nodes = this.coalesceNodesForSync(nodesPreCoalesce);
        Map timestamps = VCSBufferUtils.storeTimestamps(Arrays.asList(nodes));
        VCSDirectoryInvokableState invokableState = new VCSDirectoryInvokableState(VCSModelUtils.convertNodesToURLs((Locatable[])locatables));
        CommandState commandState = new CommandState();
        commandState.setInvokableState(invokableState);
        commandState.setLocatables(locatables);
        commandState.setTimestampMap(timestamps);
        return commandState;
    }

    protected Collection coalesceNodesForSync(Collection nodes) {
        return this.coalesceNodesForFolderOperation(nodes, false);
    }
}

