/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2.cmd;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.DialogHeader;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.vcs.generic.CommandState;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.spi.VCSCommentsCustomizer;
import oracle.jdeveloper.vcs.spi.VCSControlCache;
import oracle.jdeveloper.vcs.spi.VCSDirectoryInvokableState;
import oracle.jdeveloper.vcs.spi.VCSException;
import oracle.jdeveloper.vcs.spi.VCSRecentCommentsModel;
import oracle.jdeveloper.vcs.util.VCSBufferUtils;
import oracle.jdeveloper.vcs.util.VCSNavigableUtils;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionManager;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceShellRunner;
import oracle.jdevimpl.vcs.perforce2.PerforceURLInfoCache;
import oracle.jdevimpl.vcs.perforce2.cl.node.CLDetail;
import oracle.jdevimpl.vcs.perforce2.cmd.PerforceAbstractCommand;
import oracle.jdevimpl.vcs.perforce2.error.PerforceOperationException;
import oracle.jdevimpl.vcs.perforce2.error.PerforceProcessException;
import oracle.jdevimpl.vcs.perforce2.res.Bundle;
import oracle.jdevimpl.vcs.perforce2.res.PerforceArb;
import oracle.jdevimpl.vcs.perforce2.ui.ChangeListPanel;
import oracle.jdevimpl.vcs.perforce2.ui.PerforceChangelistSelectionListener;
import oracle.jdevimpl.vcs.perforce2.ui.SelectChangelistPanel;
import oracle.jdevimpl.vcs.perforce2.ui.SelectionEvent;
import oracle.jdevimpl.vcs.perforce2.util.ChangeListFile;
import oracle.jdevimpl.vcs.perforce2.util.PerforceCommands;
import oracle.jdevimpl.vcs.perforce2.util.PerforceSubmitted;
import oracle.jdevimpl.vcs.perforce2.util.PerforceTemplates;
import oracle.jdevimpl.vcs.perforce2.util.PerforceUtil;
import oracle.jdevimpl.vcs.xspi.ALMCommitFile;

public class PerforceSubmitChangelistCommand
extends PerforceAbstractCommand {
    public static final String COMMAND_ID = "oracle.jdeveloper.perforce2.submitchangelist";
    private Collection<ChangeListFile> _changelistFiles = new HashSet<ChangeListFile>();
    private static Logger sLogger = PerforceProfile.getQualifiedLogger(PerforceSubmitChangelistCommand.class.getName());
    private CLDetail _changelist;
    private static VCSRecentCommentsModel _recentCommentsModel;
    private String _errChangelist;

    public PerforceSubmitChangelistCommand() {
        super(COMMAND_ID);
    }

    public PerforceSubmitChangelistCommand(String commandId) {
        super(commandId);
    }

    public boolean invokeCommand(VCSProfile profile, CommandState commandState) throws Exception {
        final PerforceSubmitted submitted = new PerforceSubmitted();
        this._changelist = this.getSubmitChangeList(profile);
        if (this._changelist == null) {
            return false;
        }
        this.filesOnChangelist(this._changelist.getConnectionProfile(), this._changelist.getChangelistNo());
        PerforceUtil.getWorkspaceFiles(this._changelist.getConnectionProfile(), this._changelistFiles);
        PerforceUtil.getMovedFileDetails(this._changelist.getConnectionProfile(), this._changelistFiles);
        Collection removed = this.removeNonExistance(this._changelistFiles);
        if (this._changelistFiles.size() == 0 && removed.size() > 0) {
            StringBuilder sb = new StringBuilder(PerforceArb.get("SUBMIT_NO_LOCAL_FILES"));
            Iterator it = removed.iterator();
            while (it.hasNext()) {
                sb.append('\n');
                sb.append((String)it.next());
            }
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)sb.toString(), (String)PerforceArb.get("SUBMIT_NO_LOCAL_FILES_TITLE"), null);
            return false;
        }
        final Collection<Locatable> locatables = this.getLocatables(this._changelistFiles);
        if (!this.saveDirtyNodes(locatables.toArray(new Locatable[0]))) {
            return false;
        }
        URL[] urls = this.getUrlsFromChangelist(this._changelistFiles);
        VCSDirectoryInvokableState invokableState = new VCSDirectoryInvokableState(urls);
        Map timestamps = VCSBufferUtils.storeTimestamps(locatables);
        final VCSCommentsCustomizer customizer = new VCSCommentsCustomizer("oracle.jdeveloper.perforce");
        customizer.setShowReuseCommentsOption(false);
        customizer.setRecentCommentsModel(this.getRecentCommentsModel());
        customizer.setShowTemplatesAndCommentsCombo(true);
        customizer.setTemplatesSettingsPath(VCSNavigableUtils.getSystemNavigablePath((String)Bundle.get("PERFORCE_SHORT_NAME"), (String[])new String[]{VCSCommentsCustomizer.COMMENT_TEMPLATES_NAVIGABLE_LABEL}));
        final ChangeListPanel panel = new ChangeListPanel(this._changelist.getConnectionProfile(), this._changelistFiles, customizer);
        JEWTDialog dialog = this.createSubmitDialog(panel, customizer);
        panel.setFileHeader(PerforceArb.get("SUBMIT_FILES_CHANGELIST"));
        DialogHeader header = new DialogHeader();
        header.setHeaderDescription(PerforceArb.get("SUBMIT_CHANGE_LIST_HEADER"));
        HelpSystem.getHelpSystem().registerTopic((JComponent)panel, this.getHelpTopicId());
        dialog.setDialogHeader((Component)header);
        dialog.addVetoableChangeListener(new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt)) {
                    try {
                        customizer.validateOptions();
                        submitted.copy(PerforceSubmitChangelistCommand.this.submitChangeList(panel.getUnSelectedCLFilesAndActions(), panel.getCLFilesAndActions(), PerforceSubmitChangelistCommand.this._changelist.getChangelistNo(), panel.getDescription(), PerforceSubmitChangelistCommand.this._changelist.getConnectionProfile()));
                    }
                    catch (PerforceProcessException e) {
                        Locatable[] locs = locatables.toArray(new Locatable[0]);
                        try {
                            PerforceSubmitChangelistCommand.this._errChangelist = PerforceUtil.getChangelistNo(PerforceSubmitChangelistCommand.this._changelist.getConnectionProfile(), locs[0].getURL());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        PerforceProfile.getErrorHandler().handleException((Exception)((Object)e));
                        throw new PropertyVetoException("", evt);
                    }
                    catch (VCSException ex) {
                        PerforceProfile.getErrorHandler().handleException((Exception)((Object)ex));
                        throw new PropertyVetoException("", evt);
                    }
                }
            }
        });
        boolean stat = dialog.runDialog();
        if (stat) {
            this.postInvoke(profile, this._changelist.getConnectionProfile(), timestamps, this.getUrls(panel.getCLFilesAndActions()));
        } else if (this._errChangelist != null) {
            this.postErrorInvoke(profile, this._changelist.getConnectionProfile(), this.getUrls(panel.getCLFilesAndActions()), this._errChangelist);
        }
        return stat;
    }

    @Override
    protected boolean invokeCommandSilentlyImpl(VCSProfile profile, CommandState commandState, Map options) throws Exception {
        this._changelist = this.getSubmitChangeList(profile);
        if (this._changelist == null) {
            return false;
        }
        this.filesOnChangelist(this._changelist.getConnectionProfile(), this._changelist.getChangelistNo());
        PerforceUtil.getWorkspaceFiles(this._changelist.getConnectionProfile(), this._changelistFiles);
        Collection<Locatable> locatables = this.getLocatables(this._changelistFiles);
        if (!this.saveDirtyNodes(locatables.toArray(new Locatable[0]))) {
            return false;
        }
        Map timestamps = VCSBufferUtils.storeTimestamps(locatables);
        try {
            boolean defaultCL = this._changelist.getChangelistNo().equals(PerforceUtil.getDefaultChangelist(this._changelist.getConnectionProfile()));
            if (!defaultCL) {
                PerforceCommands.submitChangelist(this._changelist.getChangelistNo(), this.getComments(options), this._changelist.getConnectionProfile());
            } else {
                this.submit(this._changelistFiles, this.getComments(options), this._changelist.getConnectionProfile());
            }
        }
        catch (PerforceProcessException e) {
            PerforceProfile.getErrorHandler().handleException((Exception)((Object)e));
            return false;
        }
        this.postInvoke(profile, this._changelist.getConnectionProfile(), timestamps, this.getUrls(this._changelistFiles));
        return true;
    }

    private JEWTDialog createSubmitDialog(ChangeListPanel component, VCSCommentsCustomizer customizer) {
        int buttons = 3;
        if (this.getHelpTopicId() != null) {
            buttons |= 4;
        }
        JPanel content = new JPanel(new BorderLayout());
        content.add((Component)component, "Center");
        content.add(customizer.getComponent(), "South");
        JEWTDialog dialog = OnePageWizardDialogFactory.createJEWTDialog((Component)VCSWindowUtils.getCurrentWindow(), (Component)content, (Component)customizer.getInitialFocusComponent(), (String)(this.getDialogTitle() + " - " + this._changelist.getChangelistNo()), (int)buttons);
        if (this.getHelpTopicId() != null) {
            HelpSystem.getHelpSystem().registerTopic((JComponent)customizer.getComponent(), this.getHelpTopicId());
        }
        return dialog;
    }

    private String getComments(Map options) {
        String commentOption = (String)options.get("setting_comments");
        return commentOption != null ? commentOption : "";
    }

    private Collection<URL> getUrls(Collection<ChangeListFile> processed) {
        Iterator<ChangeListFile> it = processed.iterator();
        ArrayList<URL> urls = new ArrayList<URL>();
        while (it.hasNext()) {
            ChangeListFile clf = it.next();
            if (clf.getWorkspaceFile() == null) continue;
            urls.add(URLFactory.newFileURL((String)clf.getWorkspaceFile()));
        }
        return urls;
    }

    private void postErrorInvoke(VCSProfile profile, PerforceConnectionProfile connect, Collection<URL> processed, String errChangelist) throws Exception {
        URL[] urls = processed.toArray(new URL[processed.size()]);
        if (!this._changelist.getChangelistNo().equals(errChangelist)) {
            PerforceUtil.changelistSubmitted(connect, this._changelist.getChangelistNo());
            if (errChangelist != null) {
                PerforceUtil.changelistCreate(connect, errChangelist);
            }
        }
        profile.getPolicyStatusCache().clear(urls);
    }

    private void postInvoke(VCSProfile profile, PerforceConnectionProfile connect, final Map timestamps, Collection<URL> processed) throws Exception {
        if (processed.size() > 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    VCSBufferUtils.reloadBuffers((Map)timestamps);
                }
            });
        }
        URL[] urls = processed.toArray(new URL[processed.size()]);
        this.fireFileStructureChanged(urls);
        PerforceUtil.changelistSubmitted(connect, this._changelist.getChangelistNo());
        PerforceURLInfoCache.getInstance().clearChangelist(urls);
        profile.getPolicyStatusCache().clear(urls);
        VCSControlCache.getInstance().fireControlStateChanged(profile.getID());
    }

    private PerforceSubmitted submitChangeList(Collection<ChangeListFile> removeFiles, Collection<ChangeListFile> changelistFiles, String changelistNo, String comment, PerforceConnectionProfile connect) throws PerforceProcessException {
        boolean defaultCL;
        try {
            defaultCL = changelistNo.equals(PerforceUtil.getDefaultChangelist(connect));
        }
        catch (Exception e) {
            throw new PerforceProcessException(PerforceArb.get("MOVE_CHANGELIST_TITLE"), PerforceArb.get("SUBMIT_DEFAULT_CHANGELIST_ERROR"), e.getMessage());
        }
        if (removeFiles.size() > 0 && !defaultCL) {
            this.moveFilesToDefault(removeFiles, connect);
        }
        if (!defaultCL) {
            return PerforceCommands.submitChangelist(changelistNo, comment, connect);
        }
        return this.submit(changelistFiles, comment, connect);
    }

    private PerforceSubmitted submit(Collection<ChangeListFile> changelistFile, String comment, PerforceConnectionProfile connect) throws PerforceProcessException {
        PerforceSubmitted submitted = new PerforceSubmitted();
        List<String> files = this.getDeptFiles(changelistFile);
        PerforceShellRunner runner = new PerforceShellRunner();
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("submit");
        cmd.add("-i");
        runner.setCmdList(cmd);
        runner.setQuiet(true);
        runner.setInputData(PerforceTemplates.getSubmitTemplate(files, comment));
        runner.addOutputMonitor(submitted);
        runner.setConnection(connect);
        try {
            runner.exec();
        }
        catch (Exception e) {
            throw new PerforceProcessException(PerforceArb.get("MOVE_CHANGELIST_TITLE"), PerforceArb.get("SUBMIT_DEFAULT_CHANGELIST_ERROR"), e.getMessage());
        }
        if (runner.getExitCode() == null || runner.getExitCode() != 0) {
            PerforceUtil.isErrorConnection(runner, connect, PerforceArb.get("MOVE_CHANGELIST_TITLE"));
            throw new PerforceProcessException(PerforceArb.get("MOVE_CHANGELIST_TITLE"), PerforceArb.get("SUBMIT_DEFAULT_CHANGELIST_ERROR"), runner.getErrorText());
        }
        return submitted;
    }

    private Locatable[] getSubmitContextLocatables(VCSProfile profile) {
        Locatable[] locs = super.getContextLocatables();
        if (locs.length > 0) {
            return locs;
        }
        Context context = this.getContext();
        locs = PerforceCommands.getPendingChangelistNodes(profile, context);
        return locs;
    }

    private CLDetail getSubmitChangeList(VCSProfile profile) {
        Collection<CLDetail> changelist = this.getChangelistToSubmit(profile, this.getSubmitContextLocatables(profile));
        CLDetail changelistno = null;
        if (changelist.size() > 1) {
            SelectChangelistPanel panel = new SelectChangelistPanel(changelist);
            final JEWTDialog dialog = OnePageWizardDialogFactory.createJEWTDialog((Component)panel, (Component)panel.getDefaultComponent(), (String)PerforceArb.get("CHANGELIST_MORE_ONE_TITLE"));
            HelpSystem.getHelpSystem().registerTopic((JComponent)panel, "f1_pfcselectchangelist_html");
            panel.addChangelistListener(new PerforceChangelistSelectionListener(){

                @Override
                public void stateChanged(SelectionEvent selection) {
                    if (selection.getNoSelectedChangelist() == 1) {
                        dialog.setOKButtonEnabled(true);
                    } else {
                        dialog.setOKButtonEnabled(false);
                    }
                }
            });
            dialog.setOKButtonEnabled(false);
            if (dialog.runDialog()) {
                changelistno = panel.getSelectedChangelist();
            }
        } else {
            CLDetail[] cList = changelist.toArray(new CLDetail[0]);
            changelistno = cList[0];
        }
        return changelistno;
    }

    private Collection<CLDetail> getChangelistToSubmit(VCSProfile profile, Locatable[] locatables) {
        URLFilter filter = profile.getURLFilter("oracle.jdeveloper.perforce.filters.url.PENDING_CHANGELIST");
        HashMap<String, CLDetail> changelist = new HashMap<String, CLDetail>();
        for (Locatable locatable : locatables) {
            CLDetail cl;
            if (filter.accept(locatable.getURL())) {
                cl = (CLDetail)((Element)locatable).getData();
            } else {
                String clNo = PerforceURLInfoCache.getInstance().getChangeList(locatable.getURL());
                PerforceConnectionProfile connect = PerforceConnectionManager.getInstance().getConnectionProfile(locatable.getURL());
                cl = new CLDetailImpl(connect, clNo);
            }
            if (cl.getChangelistNo() == null || changelist.containsKey(cl.getChangelistNo())) continue;
            changelist.put(cl.identifer(), cl);
        }
        return changelist.values();
    }

    private void filesOnChangelist(PerforceConnectionProfile connect, String changelistNo) throws PerforceOperationException {
        this._changelistFiles = PerforceCommands.getOpenFilesOnChangelist(connect, changelistNo);
    }

    private void moveFilesToDefault(Collection<ChangeListFile> removeFiles, PerforceConnectionProfile connect) throws PerforceProcessException {
        PerforceShellRunner runner = new PerforceShellRunner();
        ArrayList<String> cmds = new ArrayList<String>();
        runner.setConnection(connect);
        try {
            cmds.add("reopen");
            cmds.add("-c");
            cmds.add(PerforceUtil.getDefaultChangelist(connect));
            for (ChangeListFile clFile : removeFiles) {
                cmds.add(clFile.getWorkspaceFile());
            }
            runner.setCmdList(cmds);
            runner.exec();
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "Failed to move the unselected files to the default changelist", e);
            throw new PerforceProcessException(PerforceArb.get("MOVE_CHANGELIST_TITLE"), PerforceArb.get("ERROR_MOVE_CHANGELIST"), e.getMessage() != null ? e.getMessage() : "");
        }
        if (runner.getExitCode() == null || runner.getExitCode() != 0) {
            sLogger.log(Level.WARNING, "Failed to move the unselected files to the default changelist " + runner.getErrorText());
            throw new PerforceProcessException(PerforceArb.get("MOVE_CHANGELIST_TITLE"), PerforceArb.get("ERROR_MOVE_CHANGELIST"), runner.getErrorText() != null ? runner.getErrorText() : "");
        }
    }

    private List<String> getDeptFiles(Collection<ChangeListFile> changelistFile) {
        ArrayList<String> dpFiles = new ArrayList<String>();
        for (ChangeListFile clf : changelistFile) {
            dpFiles.add(clf.getDepotFile());
        }
        return dpFiles;
    }

    private Collection<Locatable> getLocatables(Collection<ChangeListFile> changelistFiles) {
        ArrayList<Locatable> loc = new ArrayList<Locatable>();
        for (ChangeListFile clf : changelistFiles) {
            String wkf = clf.getWorkspaceFile();
            Node node = NodeFactory.find((URL)URLFactory.newFileURL((String)wkf));
            if (node == null) continue;
            loc.add((Locatable)node);
        }
        return loc;
    }

    @Override
    protected String getPerforceChangelist() {
        return this._changelist.getChangelistNo();
    }

    private VCSRecentCommentsModel getRecentCommentsModel() {
        if (_recentCommentsModel == null) {
            _recentCommentsModel = new VCSRecentCommentsModel();
        }
        return _recentCommentsModel;
    }

    private Collection removeNonExistance(Collection<ChangeListFile> _changelistFiles) {
        ArrayList<String> removed = new ArrayList<String>();
        Iterator<ChangeListFile> it = _changelistFiles.iterator();
        while (it.hasNext()) {
            ChangeListFile clf = it.next();
            if (clf.isDeleteAction() || clf.isMoveAddAction() || clf.isMoveDeleteAction() || URLFileSystem.exists((URL)URLFactory.newFileURL((String)clf.getWorkspaceFile()))) continue;
            removed.add(clf.getWorkspaceFile());
            it.remove();
        }
        return removed;
    }

    private URL[] getUrlsFromChangelist(Collection<ChangeListFile> _changelistFiles) {
        ArrayList<URL> urls = new ArrayList<URL>(_changelistFiles.size());
        for (ChangeListFile clf : _changelistFiles) {
            urls.add(URLFactory.newFileURL((String)clf.getDepotFile()));
        }
        return urls.toArray(new URL[0]);
    }

    private Collection<ALMCommitFile> getALMCommitedFiles(Map<String, String> changeListFile) {
        ArrayList<ALMCommitFile> alm = new ArrayList<ALMCommitFile>();
        Iterator<String> it = changeListFile.keySet().iterator();
        while (it.hasNext()) {
            String[] dFile = it.next().split("#");
            alm.add(new ALMCommitFile(dFile[0], dFile[1]));
        }
        return alm;
    }

    private class CLDetailImpl
    implements CLDetail {
        private PerforceConnectionProfile _connect;
        private String _changeNo;
        private String _id;

        private CLDetailImpl(PerforceConnectionProfile connect, String changeNo) {
            this._connect = connect;
            this._changeNo = changeNo;
        }

        @Override
        public String getChangelistNo() {
            return this._changeNo;
        }

        @Override
        public PerforceConnectionProfile getConnectionProfile() {
            return this._connect;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CLDetail)) {
                return false;
            }
            CLDetail dt = (CLDetail)obj;
            return dt.getConnectionProfile().equals(this._connect) && this._changeNo.equals(dt.getChangelistNo());
        }

        @Override
        public String identifer() {
            if (this._id == null) {
                this._id = this._changeNo + this._connect.toString();
            }
            return this._id;
        }
    }
}

