/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2.cmd;

import java.awt.Component;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.ProductInformation;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.dialogs.progress.DeterminateProgressMonitor;
import oracle.jdeveloper.vcs.generic.CommandState;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.spi.VCSDirectoryInvokable;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceDirectoryInvokable;
import oracle.jdevimpl.vcs.perforce2.PerforceProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceShellRunner;
import oracle.jdevimpl.vcs.perforce2.cmd.PerforceAbstractCommand;
import oracle.jdevimpl.vcs.perforce2.error.PerforceProcessException;
import oracle.jdevimpl.vcs.perforce2.res.PerforceArb;
import oracle.jdevimpl.vcs.perforce2.util.PerforceUtil;

public class PerforceRevertCommand
extends PerforceAbstractCommand {
    public static final String COMMAND_ID = "oracle.jdeveloper.perforce2.revert";
    private static final Logger sLogger = PerforceProfile.getQualifiedLogger(PerforceRevertCommand.class.getName());
    private String _changelistNo;

    public PerforceRevertCommand() {
        super(COMMAND_ID);
    }

    @Override
    protected VCSDirectoryInvokable createDirectoryInvokable(final PerforceConnectionProfile connect, VCSProfile profile, CommandState commandState, Map options) {
        final PerforceShellRunner runner = new PerforceShellRunner();
        runner.setCommand("revert");
        runner.setQuiet(false);
        runner.setConnection(connect);
        return new PerforceDirectoryInvokable(commandState.getInvokableState(), 10){

            @Override
            protected final boolean doInvocation2(URL parent, URL[] invokeUrls) throws Exception {
                PerforceRevertCommand.this._changelistNo = PerforceUtil.getChangelistNo(connect, invokeUrls[0]);
                String[] filenames = PerforceUtil.getURLFileNamesAndConvertToAscii(invokeUrls);
                ArrayList<String> filenames2 = new ArrayList<String>(Arrays.asList(filenames));
                for (int i = 0; i < filenames.length; ++i) {
                    if (!URLFileSystem.isDirectory((URL)invokeUrls[i])) continue;
                    filenames2.remove(filenames[i]);
                }
                if (filenames2.size() <= 0) {
                    return true;
                }
                runner.setOptionDirURL(parent);
                runner.setFiles(filenames2);
                runner.exec();
                if (runner.getExitCode() == null || runner.getExitCode() != 0) {
                    sLogger.log(Level.WARNING, " Fail to revert " + runner.getErrorText());
                    PerforceUtil.isErrorConnection(runner, connect, PerforceArb.get("ERROR_REVERT_FILTERED_TITLE"));
                    throw new PerforceProcessException(PerforceArb.get("ERROR_REVERT_FILTERED_TITLE"), PerforceArb.format("ERROR_REVERT_FILTERED", ProductInformation.getProductInformation().getShortName()), runner.getErrorText());
                }
                return true;
            }
        };
    }

    @Override
    protected String getPerforceChangelist() {
        return this._changelistNo;
    }

    @Override
    protected DeterminateProgressMonitor createProgressMonitor(Component parent) {
        DeterminateProgressMonitor monitor = new DeterminateProgressMonitor(parent, PerforceArb.get("REVERT_PROGRESS_TITLE"), (Object)PerforceArb.get("REVERT_WATCHER_DESCRIPTION"), "", 0, -1);
        return monitor;
    }
}

