/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2.cmd;

import java.awt.Component;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import oracle.ide.config.Preferences;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.progress.DeterminateProgressMonitor;
import oracle.jdeveloper.merge.MergeUtil;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfileRegistry;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizer;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionManager;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceMergeNode;
import oracle.jdevimpl.vcs.perforce2.PerforceShellRunner;
import oracle.jdevimpl.vcs.perforce2.cmd.PerforceAbstractCommand;
import oracle.jdevimpl.vcs.perforce2.cmd.custom.PerforceResolveCustomizer;
import oracle.jdevimpl.vcs.perforce2.error.PerforceProcessException;
import oracle.jdevimpl.vcs.perforce2.merge.PerforceMergeEditor;
import oracle.jdevimpl.vcs.perforce2.prefs.PerforceVersionToolsPreferences;
import oracle.jdevimpl.vcs.perforce2.res.PerforceArb;

public class PerforceResolveCommand
extends PerforceAbstractCommand {
    public static final String COMMAND_ID = "oracle.jdeveloper.perforce2.resolve";

    public static boolean isEditorAvailable(URL url) throws Exception {
        VCSProfile profile = VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.perforce");
        if (profile != null && "oracle.jdeveloper.perforce".equals(profile.getID())) {
            URLFilter wcf = profile.getURLFilter("oracle.jdeveloper.perforce.filters.url.CLIENT_ROOT");
            if (PerforceResolveCommand.getLocalFilter().accept(url) && URLFileSystem.exists((URL)url) && wcf.accept(url)) {
                return profile.getPolicyStatusCache().get(url) == profile.getStatusInstance("UNRESOLVED");
            }
        }
        return false;
    }

    public PerforceResolveCommand() {
        super(COMMAND_ID);
    }

    protected int doitImpl() throws Exception {
        if (!this.isClientMerge()) {
            URL url = this.getContext().getNode().getURL();
            PerforceConnectionProfile connect = PerforceConnectionManager.getInstance().getConnectionProfile(url);
            this.runServerSideMerge(connect, url);
            return 0;
        }
        Node node = this.getContext().getNode();
        MergeUtil.reopenMergeEditor((Node)new PerforceMergeNode(node.getURL()), (Node)node, PerforceMergeEditor.class);
        return 0;
    }

    private boolean isClientMerge() {
        return PerforceVersionToolsPreferences.getInstance((PropertyStorage)Preferences.getPreferences()).getUseClientMerge();
    }

    private void runServerSideMerge(PerforceConnectionProfile connect, URL url) throws Exception {
        PerforceShellRunner runner = new PerforceShellRunner();
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("-s");
        cmd.add("resolve");
        cmd.add("-af");
        cmd.add("-dw");
        cmd.add(URLFileSystem.getPlatformPathName((URL)url));
        runner.setConnection(connect);
        runner.setCmdList(cmd);
        this.doInvocationImpl(runner);
    }

    @Override
    protected DeterminateProgressMonitor createProgressMonitor(Component parent) {
        DeterminateProgressMonitor monitor = new DeterminateProgressMonitor(parent, PerforceArb.get("SUBMIT_PROGRESS_TITLE"), (Object)PerforceArb.get("SUBMIT_WATCHER_DESCRIPTION"), "", 0, -1);
        return monitor;
    }

    protected VCSOptionsCustomizer createOptionsCustomizer() {
        PerforceResolveCustomizer customizer = new PerforceResolveCustomizer();
        return customizer;
    }

    private void doInvocationImpl(PerforceShellRunner runner) throws Exception {
        try {
            runner.exec();
        }
        catch (IOException ioe) {
            throw new PerforceProcessException(PerforceArb.get("ERROR_RESOLVE_TITLE"), PerforceArb.get("ERROR_COMMAND_RESOLVE_FAILED"), ioe.getMessage());
        }
        if (runner.getExitCode() == null || runner.getExitCode() != 0) {
            throw new PerforceProcessException(PerforceArb.get("ERROR_RESOLVE_TITLE"), PerforceArb.get("ERROR_RESOLVE_FAILED"), runner.getErrorText());
        }
    }

    @Override
    protected String getPerforceChangelist() {
        return null;
    }
}

