/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2.cmd;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.bali.ewt.dialog.DialogHeader;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionManager;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceSessionManager;
import oracle.jdevimpl.vcs.perforce2.cmd.PerforceLogoutCommand;
import oracle.jdevimpl.vcs.perforce2.res.PerforceArb;
import oracle.jdevimpl.vcs.perforce2.ui.PerforceConnectionPanel;

public class PerforceMultiLogoutCommand
extends PerforceLogoutCommand {
    public static final String COMMAND_ID = "oracle.jdeveloper.perforce2.mltlogout";

    public PerforceMultiLogoutCommand() {
        super(COMMAND_ID);
    }

    @Override
    protected int doitImpl(VCSProfile vcsProfile) throws Exception {
        List<PerforceConnectionProfile> connects = this.getLoggedInConnectionProfile();
        if (connects.size() == 1) {
            boolean stat = MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)PerforceArb.format("CONFIRM_LOGOUT", connects.get(0).toString()), (String)PerforceArb.get("CONFIRM_LOGOUT_TITLE"), null);
            if (stat) {
                this.setConnectionProfile(connects.get(0));
                return super.doitImpl(vcsProfile);
            }
        } else {
            PerforceConnectionPanel panel = new PerforceConnectionPanel(connects);
            JEWTDialog dialog = OnePageWizardDialogFactory.createJEWTDialog((Component)panel, (Component)panel.getDefaultComponent(), (String)this.getDialogTitle());
            DialogHeader header = new DialogHeader();
            header.setHeaderDescription(this.getDialogHint());
            dialog.setDialogHeader((Component)header);
            if (dialog.runDialog()) {
                this.setConnectionProfile(panel.getConnectionProfile());
                return super.doitImpl(vcsProfile);
            }
        }
        return 1;
    }

    private List<PerforceConnectionProfile> getLoggedInConnectionProfile() throws Exception {
        ArrayList<PerforceConnectionProfile> connected = new ArrayList<PerforceConnectionProfile>();
        Collection<PerforceConnectionProfile> cons = PerforceConnectionManager.getInstance().list();
        for (PerforceConnectionProfile con : cons) {
            if (!PerforceSessionManager.getInstance().isConnected(con)) continue;
            connected.add(con);
        }
        return connected;
    }
}

