/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2.cmd;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.DialogHeader;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Node;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.spi.VCSException;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceSessionManager;
import oracle.jdevimpl.vcs.perforce2.PerforceShellRunner;
import oracle.jdevimpl.vcs.perforce2.cmd.PerforceAbstractCommand;
import oracle.jdevimpl.vcs.perforce2.res.PerforceArb;
import oracle.jdevimpl.vcs.perforce2.ui.PerforceLoginUIPanel;

public class PerforceLoginCommand
extends PerforceAbstractCommand {
    public static final String COMMAND_ID = "oracle.jdeveloper.perforce2.login";
    private PerforceConnectionProfile _connect;

    public PerforceLoginCommand() {
        super(COMMAND_ID);
    }

    public PerforceLoginCommand(String cmd) {
        super(cmd);
    }

    protected int doitImpl(VCSProfile vcsProfile) throws Exception {
        if (!this.isLoggIn()) {
            if (this.loggedInOutsideJDeveloper(this.getConnectionProfile())) {
                return 0;
            }
            PerforceLoginUIPanel loginPanel = new PerforceLoginUIPanel();
            JEWTDialog dialog = this.createLoginDialog(loginPanel);
            loginPanel.setUsername(this.getConnectionProfile().getUser());
            loginPanel.setServer(this.getConnectionProfile().getServer());
            loginPanel.setPassword(this.getConnectionProfile().getConnectionPassword());
            dialog.setOKButtonEnabled(true);
            dialog.addVetoableChangeListener((VetoableChangeListener)new LoginVetoableChangeListener());
            HelpSystem.getHelpSystem().registerTopic((JComponent)loginPanel, this.getHelpTopicId());
            if (dialog.runDialog()) {
                return 0;
            }
            return 1;
        }
        return 0;
    }

    public void setConnectionProfile(PerforceConnectionProfile connect) {
        this._connect = connect;
    }

    protected PerforceConnectionProfile getConnectionProfile() {
        Node node;
        if (this._connect == null && (node = this.getContext().getNode()).getData() instanceof PerforceConnectionProfile) {
            this._connect = (PerforceConnectionProfile)node.getData();
        }
        return this._connect;
    }

    protected JEWTDialog createLoginDialog(PerforceLoginUIPanel content) {
        JEWTDialog dialog = OnePageWizardDialogFactory.createJEWTDialog((Component)VCSWindowUtils.getCurrentWindow(), (Component)content, (Component)content.getInitialFocusCompontent(), (String)this.getDialogTitle(), (int)7);
        DialogHeader header = new DialogHeader();
        header.setHeaderDescription(this.getDialogHint());
        dialog.setDialogHeader((Component)header);
        return dialog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLogin(JEWTDialog dialog, char[] passwd) throws Exception {
        PerforceConnectionProfile connect = this.getConnectionProfile();
        IndeterminateProgressMonitor progressMonitor = new IndeterminateProgressMonitor((Component)dialog, PerforceArb.get("OPERATION_LOGIN_PROGRESS_TITLE"), (Object)PerforceArb.get("OPERATION_LOGIN_PROGRESS_MESSAGE"), null);
        progressMonitor.setMillisToPopup(1000);
        progressMonitor.setCloseOnFinish(true);
        progressMonitor.start();
        try {
            connect.setPassword(passwd);
            boolean success = PerforceSessionManager.getInstance().connect(connect);
            if (!success) {
                throw new Exception(PerforceArb.get("LOGIN_FAILED_PASSWORD"));
            }
            connect.setPassword(new char[0]);
        }
        finally {
            progressMonitor.finish();
        }
    }

    private boolean isLoggIn() {
        PerforceConnectionProfile connect = this.getConnectionProfile();
        return PerforceSessionManager.getInstance().isConnected(connect);
    }

    @Override
    protected String getPerforceChangelist() {
        return null;
    }

    private boolean loggedInOutsideJDeveloper(PerforceConnectionProfile connection) throws Exception {
        if (!PerforceSessionManager.getInstance().isClientInstalled()) {
            throw new VCSException(PerforceArb.get("ERROR_P4_TITLE"), PerforceArb.get("ERROR_P4_CLIENT"));
        }
        PerforceShellRunner runner = new PerforceShellRunner();
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.add("-p");
        cmds.add(connection.getServer());
        cmds.add("-u");
        cmds.add(connection.getUser());
        cmds.add("login");
        cmds.add("-s");
        runner.setCmdList(cmds);
        runner.setQuiet(true);
        runner.exec();
        String output = runner.getOutputText();
        if (output.contains(connection.getUser()) && output.contains("ticket expires")) {
            connection.setAutoLogIn(true);
            PerforceSessionManager.getInstance().connect(connection, false);
            return true;
        }
        return false;
    }

    protected class LoginVetoableChangeListener
    implements VetoableChangeListener {
        protected LoginVetoableChangeListener() {
        }

        @Override
        public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
            if (!JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt)) {
                return;
            }
            final JEWTDialog dialog = (JEWTDialog)evt.getSource();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        PerforceLoginCommand.this.doLogin(dialog, ((PerforceLoginUIPanel)dialog.getContent()).getPassword());
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                dialog.dispose();
                            }
                        });
                    }
                    catch (Exception de) {
                        MessageDialog.error((Component)dialog, (Object)de.getMessage(), (String)PerforceArb.get("OPERATION_LOGIN_ERROR_TITLE"), null);
                    }
                }
            }, "Perforce-login-thread").start();
            throw new PropertyVetoException(null, evt);
        }
    }
}

