/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2.cmd;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.runner.Runner;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.ImageIconCache;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionManager;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceSessionManager;
import oracle.jdevimpl.vcs.perforce2.PerforceShellRunner;
import oracle.jdevimpl.vcs.perforce2.cmd.PerforceAbstractCommand;
import oracle.jdevimpl.vcs.perforce2.error.PerforceOperationException;
import oracle.jdevimpl.vcs.perforce2.prefs.PerforceSystemPreferences;
import oracle.jdevimpl.vcs.perforce2.res.PerforceArb;

public class PerforceLaunchClientCommand
extends PerforceAbstractCommand {
    public static final String COMMAND_ID = "oracle.jdeveloper.perforce2.client";
    private static final String PERFORCE_CLIENT = "p4v";

    public PerforceLaunchClientCommand() {
        super(COMMAND_ID);
    }

    protected int doitImpl() throws Exception {
        String clientCommand = this.getLaunchClient();
        URL url = VCSFileSystemUtils.searchSystemPath((String)clientCommand);
        if (url == null) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)PerforceArb.format("ERROR_LAUNCH_CLIENT_NOT_FOUND", clientCommand), (String)PerforceArb.get("ERROR_TITLE"), null);
            return 1;
        }
        PerforceConnectionProfile con = this.getLoggedInConnection();
        final PerforceShellRunner runner = new PerforceShellRunner();
        runner.setQuiet(false);
        runner.setClientCommand(clientCommand);
        if (con != null) {
            runner.setConnection(con);
        }
        runner.setWait(false);
        runner.setTimeout(-1L);
        runner.getSimpleProcess().setAddToProcessesFolder(true);
        runner.getSimpleProcess().setIcon((Icon)ImageIconCache.get((URL)PerforceArb.class.getResource(PerforceArb.get("LAUNCH_CLIENT_CONTROL_IMAGE"))));
        try {
            runner.exec();
        }
        catch (IOException ex) {
            throw new PerforceOperationException(PerforceArb.format("ERROR_LAUNCH_CLIENT", clientCommand));
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Runner.getRunner().selectProcess(runner.getSimpleProcess().getRunProcess());
                runner.getSimpleProcess().setLabel("P4V");
            }
        });
        return 0;
    }

    private String getLaunchClient() {
        String client = PerforceSystemPreferences.getInstance((PropertyStorage)Preferences.getPreferences()).getPerforceCommandLocation();
        StringBuilder cmd = new StringBuilder();
        int pos = client.lastIndexOf(File.separatorChar);
        if (pos > -1) {
            cmd.append(client.subSequence(0, pos));
            cmd.append(File.separatorChar);
            cmd.append(PERFORCE_CLIENT);
            if (URLFileSystem.exists((URL)URLFactory.newFileURL((String)cmd.toString()))) {
                return cmd.toString();
            }
        }
        return PERFORCE_CLIENT;
    }

    private PerforceConnectionProfile getLoggedInConnection() {
        PerforceConnectionProfile conlog = null;
        try {
            Collection<PerforceConnectionProfile> cons = PerforceConnectionManager.getInstance().list();
            for (PerforceConnectionProfile con : cons) {
                if (!PerforceSessionManager.getInstance().isConnected(con)) continue;
                if (conlog == null) {
                    conlog = con;
                    continue;
                }
                return null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return conlog;
    }
}

