/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2.cmd;

import java.net.URL;
import oracle.ide.model.Dirtyable;
import oracle.ide.model.Locatable;
import oracle.jdeveloper.history.HistoryEntrySelector;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.spi.VCSStatusFilter;
import oracle.jdevimpl.vcs.perforce2.PerforceRevisionNumber;
import oracle.jdevimpl.vcs.perforce2.PerforceURLInfoCache;
import oracle.jdevimpl.vcs.perforce2.cmd.PerforceCompare;
import oracle.jdevimpl.vcs.perforce2.util.PerforceCommands;

public class PerforceComparePrevious
extends PerforceCompare {
    public static final String COMMAND_ID = "oracle.jdeveloper.perforce2.compare-previous";

    public PerforceComparePrevious() {
        super(COMMAND_ID);
    }

    protected Object getContextRevision(VCSProfile profile, Locatable locatable) throws Exception {
        VCSStatus stat;
        URL url = locatable.getURL();
        PerforceRevisionNumber revision = PerforceURLInfoCache.getInstance().getRevisionInfo(url);
        boolean baseCompare = locatable instanceof Dirtyable && ((Dirtyable)locatable).isDirty();
        VCSStatusFilter filter = profile.getStatusFilter("oracle.jdeveloper.perforce2.filter.status.OPEN");
        if (filter.accept(stat = (VCSStatus)profile.getPolicyStatusCache().get(url))) {
            baseCompare = PerforceCommands.isLocallyModified(url);
        }
        if (!baseCompare) {
            String previous = PerforceCommands.getPreviousRevision(url, revision.getHaveRevision());
            revision = PerforceRevisionNumber.createRevisionNumber(previous, revision.getHeadRevision());
        }
        return revision;
    }

    protected HistoryEntrySelector getHistoryEntrySelector(VCSProfile profile, Locatable source, Object revision) {
        return new HistoryEntrySelector(((PerforceRevisionNumber)revision).getHaveRevision());
    }
}

