/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2.cmd;

import java.awt.Component;
import java.net.URL;
import java.util.Collections;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfileRegistry;
import oracle.jdeveloper.vcs.spi.VCSCheckOutNodeCmd;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.util.VCSBufferUtils;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionManager;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceShellRunner;
import oracle.jdevimpl.vcs.perforce2.res.PerforceArb;

public class PerforceCheckOutNode
extends VCSCheckOutNodeCmd {
    public PerforceCheckOutNode() {
        super(0, PerforceArb.get("CHECK_OUT_NODE_CMD_NAME"));
    }

    protected boolean canCheckOutUI(URL url) {
        return MessageDialog.confirm((Component)VCSWindowUtils.getCurrentWindow(), (Object)PerforceArb.format("CONFIRM_EDIT", URLFileSystem.getPlatformPathName((URL)url)), (String)PerforceArb.get("CONFIRM_EDIT_TITLE"), null, (boolean)false);
    }

    protected boolean undoCheckOut(URL url) throws Exception {
        PerforceConnectionProfile connect = PerforceConnectionManager.getInstance().getConnectionProfile(url);
        VCSProfile profile = VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.perforce");
        VCSStatus status = (VCSStatus)profile.getPolicyStatusCache().get(url);
        if (!status.isVersioned() || URLFileSystem.isDirectory((URL)url)) {
            return false;
        }
        long timestamp = URLFileSystem.lastModified((URL)url);
        PerforceShellRunner runner = new PerforceShellRunner();
        runner.setConnection(connect);
        runner.setFiles(Collections.singletonList(URLFileSystem.getPlatformPathName((URL)url)));
        runner.setCommand("revert");
        runner.setQuiet(false);
        runner.exec();
        if (URLFileSystem.lastModified((URL)url) != timestamp) {
            VCSBufferUtils.reloadBuffer((URL)url);
        }
        if (runner.getExitCode() == null || runner.getExitCode() != 0) {
            return false;
        }
        profile.getPolicyStatusCache().clear(url);
        return URLFileSystem.isReadOnly((URL)url);
    }
}

