/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2.cmd;

import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import oracle.ide.Ide;
import oracle.ide.net.URLFileSystem;
import oracle.ide.runner.RunProcess;
import oracle.jdeveloper.vcs.annotations.Annotations;
import oracle.jdeveloper.vcs.annotations.AnnotationsCommand;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfileRegistry;
import oracle.jdeveloper.vcs.migrate.VCSStreamMonitor;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.spi.VCSStatusFilter;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionManager;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceRevisionNumber;
import oracle.jdevimpl.vcs.perforce2.PerforceSessionManager;
import oracle.jdevimpl.vcs.perforce2.PerforceShellRunner;
import oracle.jdevimpl.vcs.perforce2.PerforceURLInfoCache;

public class PerforceAnnotationCommand
extends AnnotationsCommand {
    private static final String COMMAND_ID = "oracle.jdeveloper.perforce2.annotation";

    public PerforceAnnotationCommand() {
        super(Ide.findOrCreateCmdID((String)COMMAND_ID));
    }

    protected boolean isUnmodifiedStatus(VCSStatus status) {
        VCSProfile profile = VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.perforce");
        VCSStatusFilter openFilter = profile.getStatusFilter("oracle.jdeveloper.perforce2.filter.status.OPEN");
        return !openFilter.accept(status);
    }

    protected Annotations getAnnotations(URL url) throws Exception {
        return new AnnotationsImpl(url);
    }

    private class AnnotateInfo {
        private String _codeline;
        private String _revision;

        AnnotateInfo(String codeline, String revisionNo) {
            this._revision = revisionNo;
            this._codeline = codeline;
        }

        public String getCodeline() {
            return this._codeline;
        }

        public String getRevision() {
            return this._revision;
        }
    }

    private class RevisionInfo {
        private Date _changedate;
        private String _author;

        RevisionInfo(Date date, String author) {
            this._changedate = date;
            this._author = author;
        }

        public Date getChangedate() {
            return this._changedate;
        }

        public String getAuthor() {
            return this._author;
        }
    }

    private class AnnotationsImpl
    extends Annotations {
        private Map<Integer, AnnotateInfo> _annotateMap = new HashMap<Integer, AnnotateInfo>();
        private Map<String, RevisionInfo> _revisionMap = new HashMap<String, RevisionInfo>();

        private AnnotationsImpl(URL url) throws Exception {
            PerforceConnectionProfile connect = PerforceConnectionManager.getInstance().getConnectionProfile(url);
            if (!PerforceSessionManager.getInstance().isConnected(connect)) {
                return;
            }
            PerforceRevisionNumber revision = PerforceURLInfoCache.getInstance().getRevisionInfo(url);
            this.getAnnotations(connect, url, revision.getHaveRevision());
            this.getRevisionInfo(connect, url, revision.getHaveRevision());
        }

        public Date getChanged(int lineNumber) {
            RevisionInfo rInfo;
            AnnotateInfo info = this._annotateMap.get(lineNumber);
            if (info != null && (rInfo = this._revisionMap.get(info.getRevision())) != null) {
                return rInfo.getChangedate();
            }
            return null;
        }

        public String getRevision(int lineNumber) {
            AnnotateInfo info = this._annotateMap.get(lineNumber);
            if (info != null) {
                return info.getRevision();
            }
            return null;
        }

        public String getAuthor(int lineNumber) {
            RevisionInfo rInfo;
            AnnotateInfo info = this._annotateMap.get(lineNumber);
            if (info != null && (rInfo = this._revisionMap.get(info.getRevision())) != null) {
                return rInfo.getAuthor();
            }
            return null;
        }

        public String getLine(int lineNumber) {
            AnnotateInfo info = this._annotateMap.get(lineNumber);
            if (info != null) {
                return info.getCodeline();
            }
            return null;
        }

        public int getLineCount() {
            return this._annotateMap.size();
        }

        private void getAnnotations(PerforceConnectionProfile connect, URL url, String revision) throws Exception {
            PerforceShellRunner runner = new PerforceShellRunner();
            runner.setConnection(connect);
            runner.setFiles(Collections.singletonList(URLFileSystem.getPlatformPathName((URL)url) + "#" + revision));
            runner.setCommand("annotate");
            runner.setQuiet(true);
            runner.addOutputMonitor(new AnnotateMonitor());
            runner.exec();
        }

        private void getRevisionInfo(PerforceConnectionProfile connect, URL url, String revision) throws Exception {
            PerforceShellRunner runner = new PerforceShellRunner();
            runner.setConnection(connect);
            runner.setFiles(Collections.singletonList(URLFileSystem.getPlatformPathName((URL)url) + "#" + revision));
            runner.setQuiet(true);
            ArrayList<String> cmds = new ArrayList<String>();
            cmds.add("filelog");
            cmds.add("-t");
            runner.setCmdList(cmds);
            runner.addOutputMonitor(new RevisionInfoMonitor());
            runner.exec();
        }

        private class AnnotateMonitor
        extends VCSStreamMonitor {
            private Integer lineNo = 0;

            private AnnotateMonitor() {
            }

            protected void streamLine(String line, RunProcess process) throws Exception {
                if (line.startsWith("//")) {
                    return;
                }
                int revisionMark = line.indexOf(":");
                if (revisionMark > 0) {
                    String codeline = line.substring(revisionMark + 1);
                    String revisionNo = line.substring(0, revisionMark).trim();
                    AnnotationsImpl.this._annotateMap.put(new Integer(this.lineNo), new AnnotateInfo(codeline, revisionNo));
                }
                Integer n = this.lineNo;
                Integer n2 = this.lineNo = Integer.valueOf(this.lineNo + 1);
            }
        }

        private class RevisionInfoMonitor
        extends VCSStreamMonitor {
            private DateFormat _format = new SimpleDateFormat("yyyy/MM/dd:HH:mm:ss");

            private RevisionInfoMonitor() {
            }

            protected void streamLine(String line, RunProcess process) throws Exception {
                String[] parts = line.split(" ");
                if (parts.length < 10) {
                    return;
                }
                String revision = parts[1];
                int pos = parts[1].indexOf("#");
                if (pos >= 0) {
                    revision = parts[1].substring(++pos);
                }
                Date date = this._format.parse(parts[6] + ":" + parts[7]);
                AnnotationsImpl.this._revisionMap.put(revision, new RevisionInfo(date, parts[9]));
            }
        }
    }
}

