/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2.cl.node;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.logging.Logger;
import oracle.ide.Context;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.net.URLFactory;
import oracle.ide.util.Assert;
import oracle.jdeveloper.vcs.generic.VCSProfileRegistry;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceSessionManager;
import oracle.jdevimpl.vcs.perforce2.cl.PerforceCLURLFileSystemHelper;
import oracle.jdevimpl.vcs.perforce2.cl.node.CLContainer;
import oracle.jdevimpl.vcs.perforce2.cl.node.ChangelistNoNode;
import oracle.jdevimpl.vcs.perforce2.cmd.PerforceLoginCommand;
import oracle.jdevimpl.vcs.perforce2.res.PerforceArb;
import oracle.jdevimpl.vcs.perforce2.util.PerforceUtil;

public class PendingChangelistNode
implements CLContainer {
    private static final Logger sLogger = PerforceProfile.getQualifiedLogger(PendingChangelistNode.class.getName());
    private PerforceConnectionProfile _connect;

    public PendingChangelistNode(PerforceConnectionProfile connect) {
        this._connect = connect;
    }

    public String toString() {
        return PerforceArb.format("PENDING_CHANGELISTS", this.getConnectionProfile().getClient());
    }

    public PerforceConnectionProfile getConnectionProfile() {
        return this._connect;
    }

    @Override
    public Collection getChildren() throws Exception {
        if (!this.isLoggedIn(this.getConnectionProfile())) {
            return Collections.emptySet();
        }
        ArrayList<ChangelistNoNode> children = new ArrayList<ChangelistNoNode>();
        String host = this.getConnectionProfile().getHostName();
        int port = this.getConnectionProfile().getPortNumber();
        Collection changelists = PerforceUtil.getFromServerChangelistNo(this.getConnectionProfile());
        ArrayList sorted = new ArrayList(changelists);
        Collections.sort(sorted);
        Iterator it = sorted.iterator();
        URL url = URLFactory.newURL((String)PerforceCLURLFileSystemHelper.PERFORCE_CL_PROTOCOL, null, (String)host, (int)port, (String)"/", null, null);
        ChangelistNoNode changelist = new ChangelistNoNode(this.getConnectionProfile(), url, PerforceUtil.getDefaultChangelist(this.getConnectionProfile()));
        children.add(changelist);
        while (it.hasNext()) {
            String changelistno = (String)it.next();
            changelist = new ChangelistNoNode(this.getConnectionProfile(), url, changelistno);
            children.add(changelist);
        }
        return children;
    }

    private boolean isLoggedIn(PerforceConnectionProfile connection) {
        if (!PerforceSessionManager.getInstance().isConnected(connection)) {
            PerforceLoginCommand login = new PerforceLoginCommand();
            login.setConnectionProfile(this.getConnectionProfile());
            login.setProfile(VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.perforce"));
            this.invokeCommand((Command)login);
        }
        return PerforceSessionManager.getInstance().isConnected(this.getConnectionProfile());
    }

    private void invokeCommand(Command command) {
        try {
            Context con = Context.newIdeContext();
            command.setContext(con);
            CommandProcessor.getInstance().invoke(command);
        }
        catch (Exception e) {
            sLogger.warning("Failed to login " + e.getMessage());
            Assert.printStackTrace((Throwable)e);
        }
    }
}

