/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2.cl;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.EventObject;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.docking.DockableWindow;
import oracle.ide.layout.Layout;
import oracle.ide.model.Element;
import oracle.ide.net.URLFactory;
import oracle.javatools.util.ImageIconCache;
import oracle.jdevimpl.vcs.perforce2.ConnectionEvent;
import oracle.jdevimpl.vcs.perforce2.PerforceChangeListName;
import oracle.jdevimpl.vcs.perforce2.PerforceChangelistEvent;
import oracle.jdevimpl.vcs.perforce2.PerforceChangelistListener;
import oracle.jdevimpl.vcs.perforce2.PerforceChangelistManager;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionListener;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionManager;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceProfile;
import oracle.jdevimpl.vcs.perforce2.cl.ChangelistContextMenuListener;
import oracle.jdevimpl.vcs.perforce2.cl.ChangelistTreeNode;
import oracle.jdevimpl.vcs.perforce2.cl.PendingCLTreeModel;
import oracle.jdevimpl.vcs.perforce2.cl.PendingChangelistTree;
import oracle.jdevimpl.vcs.perforce2.cl.PerforceCLURLFileSystemHelper;
import oracle.jdevimpl.vcs.perforce2.cl.node.CLDetail;
import oracle.jdevimpl.vcs.perforce2.cl.node.ChangelistNoNode;
import oracle.jdevimpl.vcs.perforce2.cl.node.PendingChangelistNode;
import oracle.jdevimpl.vcs.perforce2.cl.node.ServerDepotNode;
import oracle.jdevimpl.vcs.perforce2.res.PerforceArb;
import oracle.jdevimpl.vcs.perforce2.util.PerforceUtil;

public class PerforceCLDockableWindow
extends DockableWindow {
    private static final Logger sLogger = PerforceProfile.getQualifiedLogger(PerforceCLDockableWindow.class.getName());
    private Component _ui = null;
    private ContextMenu contextMenu;
    private PendingChangelistTree _tree;

    public PerforceCLDockableWindow(String viewid) {
        super(viewid);
        this.setType(96);
    }

    public Icon getTabIcon() {
        return ImageIconCache.get((URL)PerforceArb.class.getResource(PerforceArb.get("PERFORCE_CONNECTION_ICON")));
    }

    public String getTabName() {
        return PerforceArb.get("PENDING_CHANGELIST_NAME_TAB");
    }

    public String getTitleName() {
        return PerforceArb.get("PENDING_CHANGELIST_NAME_TITLE");
    }

    public Component getGUI() {
        if (this._ui == null) {
            DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode("Root Node");
            PendingCLTreeModel treeModel = new PendingCLTreeModel(rootNode);
            try {
                Collection<PerforceConnectionProfile> cons = PerforceConnectionManager.getInstance().list();
                for (PerforceConnectionProfile con : cons) {
                    this.createCLNodeForConnection(con, treeModel, rootNode, false);
                }
            }
            catch (Exception e) {
                sLogger.log(Level.WARNING, "Error " + e.getMessage());
            }
            this._tree = new PendingChangelistTree(treeModel);
            this._ui = new JScrollPane(this._tree);
            this._tree.addMouseListener(new ContextMenuMouseListener());
            this.getHelpInfo().setHelpTopicID("");
            PerforceConnectionManager.getInstance().addConnectionListener(new CLPerforceConnectionListener());
        }
        return this._ui;
    }

    public int getDefaultVisibility(Layout layout) {
        return 1;
    }

    public final ContextMenu getContextMenu() {
        if (this.contextMenu == null) {
            this.contextMenu = new ContextMenu();
            this.contextMenu.addContextMenuListener((ContextMenuListener)new ChangelistContextMenuListener());
        }
        return this.contextMenu;
    }

    public void refresh() throws IOException {
        this._tree.refresh();
    }

    public Context getContext(EventObject event) {
        Context context = super.getContext(event);
        if (this._tree == null) {
            return context;
        }
        Collection<Element> nodes = this._tree.getElementSelection();
        if (!nodes.isEmpty()) {
            context.setEvent(event);
            context.setSelection(nodes.toArray(new Element[0]));
        }
        return context;
    }

    void close(PerforceConnectionProfile connect) throws IOException {
    }

    private void createCLNodeForConnection(PerforceConnectionProfile con, PendingCLTreeModel treeModel, DefaultMutableTreeNode rootNode, boolean notify) throws Exception {
        ServerDepotNode server = new ServerDepotNode(con);
        DefaultMutableTreeNode serverTree = new DefaultMutableTreeNode(server);
        treeModel.insertNodeInto(serverTree, rootNode, rootNode.getChildCount());
        PendingChangelistNode pNode = new PendingChangelistNode(con);
        ChangelistTreeNode pendingTree = new ChangelistTreeNode(pNode);
        pendingTree.setAllowsChildren(true);
        treeModel.insertNodeInto(pendingTree, serverTree, serverTree.getChildCount());
        PerforceChangeListName clName = PerforceChangelistManager.getInstance().getChangeListName(con);
        clName.addListener(new UIPerforceChangelistListener(pendingTree));
        if (notify) {
            this._tree.expandRootNode();
        }
    }

    private class CLPerforceConnectionListener
    implements PerforceConnectionListener {
        private CLPerforceConnectionListener() {
        }

        @Override
        public void connectionCreated(ConnectionEvent ce) {
            PerforceConnectionProfile con = ce.getSource();
            PendingCLTreeModel treeModel = (PendingCLTreeModel)PerforceCLDockableWindow.this._tree.getModel();
            DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)PerforceCLDockableWindow.this._tree.getModel().getRoot();
            try {
                PerforceCLDockableWindow.this.createCLNodeForConnection(con, treeModel, rootNode, true);
            }
            catch (Exception e) {
                sLogger.warning("Failed to create Changelist node " + e.getMessage());
            }
        }

        @Override
        public void connectionDeleted(ConnectionEvent ce) {
            PerforceConnectionProfile con = ce.getSource();
            PendingCLTreeModel treeModel = (PendingCLTreeModel)PerforceCLDockableWindow.this._tree.getModel();
            DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)PerforceCLDockableWindow.this._tree.getModel().getRoot();
            for (int n = 0; n < rootNode.getChildCount(); ++n) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)rootNode.getChildAt(n);
                ServerDepotNode userNode = (ServerDepotNode)child.getUserObject();
                if (!userNode.getConnectionProfile().equals(con)) continue;
                treeModel.removeNodeFromParent(child);
                PerforceChangelistManager.getInstance().rmConnectFromChangelist(con);
            }
        }
    }

    private class UIPerforceChangelistListener
    implements PerforceChangelistListener {
        private DefaultMutableTreeNode _clNode;

        public UIPerforceChangelistListener(DefaultMutableTreeNode pendingTree) {
            this._clNode = pendingTree;
        }

        @Override
        public void changelistCreated(PerforceChangelistEvent pce) {
            PendingCLTreeModel model = (PendingCLTreeModel)PerforceCLDockableWindow.this._tree.getModel();
            String changelistNo = pce.getChangelist();
            PendingChangelistNode pclNode = (PendingChangelistNode)this._clNode.getUserObject();
            PerforceConnectionProfile connect = pclNode.getConnectionProfile();
            if (!connect.equals(pce.getConnect())) {
                return;
            }
            URL url = URLFactory.newURL((String)PerforceCLURLFileSystemHelper.PERFORCE_CL_PROTOCOL, null, (String)connect.getHostName(), (int)connect.getPortNumber(), (String)"/", null, null);
            ChangelistNoNode changelist = new ChangelistNoNode(connect, url, changelistNo);
            ChangelistTreeNode changelistNoNode = new ChangelistTreeNode(changelist);
            model.insertNodeInto(changelistNoNode, this._clNode, this._clNode.getChildCount());
        }

        @Override
        public void changelistSubmitted(PerforceChangelistEvent pce) {
            PendingCLTreeModel model = (PendingCLTreeModel)PerforceCLDockableWindow.this._tree.getModel();
            DefaultMutableTreeNode node = null;
            PendingChangelistNode pclNode = (PendingChangelistNode)this._clNode.getUserObject();
            PerforceConnectionProfile connect = pclNode.getConnectionProfile();
            if (!connect.equals(pce.getConnect())) {
                return;
            }
            String changelistNo = pce.getChangelist();
            node = this.getNodeOfChangelist(model, changelistNo);
            try {
                if (!changelistNo.equals(PerforceUtil.getDefaultChangelist(connect))) {
                    if (node != null) {
                        model.removeNodeFromParent(node);
                    }
                } else {
                    model.reload(node);
                }
            }
            catch (Exception e) {
                sLogger.warning(e.getMessage());
            }
        }

        private DefaultMutableTreeNode getNodeOfChangelist(PendingCLTreeModel model, String changelistNo) {
            for (int c = 0; c < model.getChildCount(this._clNode); ++c) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)model.getChild(this._clNode, c);
                if (!((CLDetail)child.getUserObject()).getChangelistNo().equals(changelistNo)) continue;
                return child;
            }
            return null;
        }

        @Override
        public void changelistModified(PerforceChangelistEvent pce) {
            PendingCLTreeModel model = (PendingCLTreeModel)PerforceCLDockableWindow.this._tree.getModel();
            String changelistNo = pce.getChangelist();
            DefaultMutableTreeNode child = this.getNodeOfChangelist(model, changelistNo);
            PendingChangelistNode pclNode = (PendingChangelistNode)this._clNode.getUserObject();
            PerforceConnectionProfile connect = pclNode.getConnectionProfile();
            if (!connect.equals(pce.getConnect())) {
                return;
            }
            if (child != null) {
                model.reload(child);
            }
        }
    }

    private final class ContextMenuMouseListener
    extends MouseAdapter {
        private ContextMenuMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger() && PerforceConnectionManager.getInstance().hasConnections()) {
                this.setContextAndShowMenu(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.setContextAndShowMenu(e);
            }
        }

        private void setContextAndShowMenu(MouseEvent e) {
            PendingChangelistTree tree = (PendingChangelistTree)e.getSource();
            Point p1 = e.getPoint();
            TreePath path = tree.getPathForLocation(p1.x, p1.y);
            if (!this.isPathSelected(tree, path)) {
                tree.setSelectionPath(path);
            }
            this._showContextMenu(e);
        }

        private boolean isPathSelected(PendingChangelistTree tree, TreePath path) {
            TreePath[] paths = tree.getSelectionPaths();
            if (paths != null) {
                for (TreePath tpath : paths) {
                    if (!tpath.equals(path)) continue;
                    return true;
                }
            }
            return false;
        }

        private void _showContextMenu(MouseEvent e) {
            Collection<Element> nodes = PerforceCLDockableWindow.this._tree.getElementSelection();
            if (!nodes.isEmpty()) {
                Context context = Context.newIdeContext();
                context.setEvent((EventObject)e);
                context.setSelection(nodes.toArray(new Element[0]));
                PerforceCLDockableWindow.this.getContextMenu().show(context);
            }
        }
    }
}

