/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2.changelist;

import java.net.URL;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.vcs.changelist.ChangeList;
import oracle.jdeveloper.vcs.generic.PendingChangesAdapter;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfileRegistry;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionManager;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceURLInfoCache;
import oracle.jdevimpl.vcs.perforce2.prefs.PerforceVersionToolsPreferences;
import oracle.jdevimpl.vcs.perforce2.res.PerforceArb;
import oracle.jdevimpl.vcs.perforce2.util.PerforceUtil;

public class PerforcePendingChangesAdapter
extends PendingChangesAdapter {
    private static final String CL_ID_OUTGOING = "oracle.jdevimpl.vcs.perforce2.changelist.OUTGOING";
    private static final String CL_ID_CANDIDATES = "oracle.jdevimpl.vcs.perforce2.changelist.CANDIDATES";
    private static final String PROP_ID_CHANGE_LIST_STATUS = "changeList";
    private static final String PROP_ID_CONNECTION_STATUS = "connection";

    public VCSProfile getProfile() {
        return VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.perforce");
    }

    public Object resolvePropertyValue(String changeListId, String propertyId, URL url) {
        if (changeListId.equals(CL_ID_OUTGOING)) {
            if (propertyId.equals(PROP_ID_CHANGE_LIST_STATUS)) {
                return this.resolveOutgoingChangeListStatus(url);
            }
        } else if (changeListId.equals(CL_ID_CANDIDATES)) {
            return PerforceArb.get("CHANGE_LIST_UNADDED");
        }
        if (propertyId.equals(PROP_ID_CONNECTION_STATUS)) {
            PerforceConnectionProfile con = PerforceConnectionManager.getInstance().getConnectionProfile(url);
            return con.toString();
        }
        return super.resolvePropertyValue(changeListId, propertyId, url);
    }

    public boolean isActionSilent(ChangeList changeList, String actionId) {
        VCSProfile profile;
        if (actionId.equals("oracle.jdeveloper.perforce2.submitchangelist") && (profile = VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.perforce")) != null) {
            int policy = PerforceVersionToolsPreferences.getInstance((PropertyStorage)Preferences.getPreferences()).getPendingChangesDialogUsage();
            if (policy == 0) {
                return false;
            }
            if (policy == 1) {
                return changeList.isOptionsVisible();
            }
            if (policy == 2) {
                return true;
            }
            throw new IllegalStateException();
        }
        return true;
    }

    private Object resolveOutgoingChangeListStatus(URL url) {
        String changeList = PerforceURLInfoCache.getInstance().getChangeList(url);
        if (changeList != null) {
            PerforceConnectionProfile connect = PerforceConnectionManager.getInstance().getConnectionProfile(url);
            try {
                String name = PerforceUtil.getLongLabel(connect, changeList);
                return name;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return changeList;
    }
}

