/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2.changelist;

import java.util.ArrayList;
import java.util.Collection;
import oracle.ide.net.URLFactory;
import oracle.jdeveloper.vcs.changelist.ChangeList;
import oracle.jdeveloper.vcs.spi.VCSException;
import oracle.jdeveloper.vcs.spi.VCSHashURL;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceDepotInfo;
import oracle.jdevimpl.vcs.perforce2.PerforceDepotOpenedCache;
import oracle.jdevimpl.vcs.perforce2.PerforceFstatResult;
import oracle.jdevimpl.vcs.perforce2.PerforceGetStatus;
import oracle.jdevimpl.vcs.perforce2.changelist.PerforceAbstractEventQueue;

public class PerforceOutgoingEventQueue
extends PerforceAbstractEventQueue {
    private int _iBatch;

    public PerforceOutgoingEventQueue(ChangeList changeList) {
        super(changeList);
        changeList.setExcludeDirectories(true);
        String btn = System.getProperty("PERFORCE_CHANGELIST_NO");
        this._iBatch = btn == null ? 20 : Integer.parseInt(btn);
    }

    protected int getBatchCount() {
        return this._iBatch;
    }

    @Override
    protected Collection<VCSHashURL> getFiles(PerforceConnectionProfile connection) throws VCSException {
        PerforceFstatResult[] fstat;
        ArrayList<VCSHashURL> modUrl = new ArrayList<VCSHashURL>();
        ArrayList<String> dFiles = new ArrayList<String>();
        Collection<PerforceDepotInfo> dInfos = PerforceDepotOpenedCache.getInstance().getOpenDepotFiles(connection);
        for (PerforceDepotInfo dInfo : dInfos) {
            dFiles.add(dInfo.getDepotFile());
        }
        for (PerforceFstatResult fs : fstat = PerforceGetStatus.fstat(connection, dFiles)) {
            modUrl.add(new VCSHashURL(URLFactory.newFileURL((String)fs.getClientFile())));
        }
        return modUrl;
    }
}

