/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.history.HistoryEntry;
import oracle.jdeveloper.history.RestoreFromRevisionClass;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfileRegistry;
import oracle.jdeveloper.vcs.spi.VCSControlCache;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionManager;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceURLInfoCache;
import oracle.jdevimpl.vcs.perforce2.history.PerforceContent;
import oracle.jdevimpl.vcs.perforce2.util.ChangeListFile;
import oracle.jdevimpl.vcs.perforce2.util.PerforceCommands;
import oracle.jdevimpl.vcs.perforce2.util.PerforceUtil;

public class PerforceRestoreFromRevisionClass
extends RestoreFromRevisionClass {
    private Collection<ChangeListFile> _files;

    public boolean canRestore(URL[] urls, String revision, HistoryEntry entry) throws Exception {
        PerforceConnectionProfile connect = PerforceConnectionManager.getInstance().getConnectionProfile(urls[0]);
        String changeListNo = (String)entry.getValue(this.getProfile().getHistoryProperty("oracle.jdeveloper.perforce2.history.CHANGELIST"));
        this._files = PerforceCommands.getFilesOnChangelist(connect, changeListNo);
        if (this._files.isEmpty()) {
            return false;
        }
        PerforceUtil.getWorkspaceFiles(connect, this._files);
        for (URL url : urls) {
            if (this.isMemberOf(this._files, url)) continue;
            return false;
        }
        return true;
    }

    public boolean restore(URL[] urls, String revision, HistoryEntry entry) throws Exception {
        if ((this._files == null || this._files.isEmpty()) && !this.canRestore(urls, revision, entry)) {
            return false;
        }
        PerforceContent content = new PerforceContent();
        for (URL url : urls) {
            String revisionNo = this.getRevisionNo(this._files, url);
            byte[] versionContent = content.getVersionContent(url, revisionNo);
            URLFileSystem.copy((InputStream)new ByteArrayInputStream(versionContent), (URL)url);
        }
        this.clearCache(urls);
        this._files = null;
        return true;
    }

    private void clearCache(URL[] urls) {
        PerforceURLInfoCache.getInstance().clear(urls);
        this.getProfile().getStatusCacheBridge().clear(urls);
        VCSControlCache.getInstance().fireControlStateChanged(this.getProfile().getID());
    }

    private boolean isMemberOf(Collection<ChangeListFile> files, URL url) {
        for (ChangeListFile clFile : files) {
            if (!clFile.getWorkspaceFile().equals(url.getPath())) continue;
            return true;
        }
        return false;
    }

    private VCSProfile getProfile() {
        return VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.perforce");
    }

    private String getRevisionNo(Collection<ChangeListFile> files, URL url) {
        for (ChangeListFile lFile : files) {
            if (!lFile.getWorkspaceFile().equals(url.getPath())) continue;
            return lFile.getRevisionNo();
        }
        return null;
    }
}

