/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import oracle.ide.net.URLFactory;
import oracle.jdeveloper.vcs.generic.RemovedEntryLister;
import oracle.jdevimpl.vcs.perforce2.DepotFilter;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionManager;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceDepotInfo;
import oracle.jdevimpl.vcs.perforce2.PerforceDepotOpenedCache;
import oracle.jdevimpl.vcs.perforce2.PerforceSessionManager;

public class PerforceRemovedEntryLister
extends RemovedEntryLister {
    public URL[] listRemovedEntries(URL directoryUrl) throws Exception {
        int pos;
        PerforceConnectionProfile connect = PerforceConnectionManager.getInstance().getConnectionProfile(directoryUrl);
        ArrayList<URL> urls = new ArrayList<URL>();
        if (connect == null) {
            return new URL[0];
        }
        URL root = PerforceSessionManager.getInstance().getClientRootFolder(connect);
        Map<String, String> serverDepotMap = PerforceSessionManager.getInstance().getDepotRootFolders(connect);
        String locatePath = directoryUrl.getPath().substring(root.getPath().length() - 1);
        Iterator<String> dpit = serverDepotMap.keySet().iterator();
        String depotRoot = null;
        String localPath = "";
        while (dpit.hasNext()) {
            String serverPath = dpit.next();
            localPath = serverDepotMap.get(serverPath);
            if (!locatePath.startsWith(localPath)) continue;
            depotRoot = serverPath;
        }
        if (depotRoot == null) {
            return urls.toArray(new URL[0]);
        }
        if (localPath.equals("/")) {
            localPath = "";
        }
        if ((pos = localPath.indexOf(47)) > -1 && pos + 1 < localPath.length()) {
            localPath = localPath.substring(pos + 1);
        }
        final String deptDirectory = directoryUrl.getPath().replace(root.getPath() + localPath, depotRoot);
        Collection<PerforceDepotInfo> dpFiles = PerforceDepotOpenedCache.getInstance().getOpenDepotFiles(connect, new DepotFilter(){

            @Override
            public boolean accept(PerforceDepotInfo item) {
                return item.getAction() == PerforceDepotInfo.Action.DELETE && item.getDepotFile().startsWith(deptDirectory);
            }
        });
        for (PerforceDepotInfo info : dpFiles) {
            URL delURL = URLFactory.newURL((URL)directoryUrl, (String)info.getDepotFile().substring(deptDirectory.length()));
            urls.add(delURL);
        }
        return urls.toArray(new URL[0]);
    }
}

