/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2;

import java.awt.Component;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.vcs.properties.PropertiesPanel;
import oracle.jdeveloper.vcs.spi.VCSException;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionManager;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceFstatResult;
import oracle.jdevimpl.vcs.perforce2.PerforceGetStatus;
import oracle.jdevimpl.vcs.perforce2.PerforceProfile;
import oracle.jdevimpl.vcs.perforce2.ui.PerforcePropertiesPanelUI;

public class PerforcePropertiesPanel
extends PropertiesPanel {
    private static final Logger sLogger = PerforceProfile.getQualifiedLogger(PerforcePropertiesPanel.class.getName());
    private URL url;
    private PerforceConnectionProfile _connect;

    public PerforcePropertiesPanel(URL url) {
        this.url = url;
        this._connect = PerforceConnectionManager.getInstance().getConnectionProfile(url);
    }

    public Component getComponent() {
        try {
            PerforceFstatResult stat = PerforceGetStatus.fstat(this._connect, URLFileSystem.getPlatformPathName((URL)this.url));
            PerforcePropertiesPanelUI panel = new PerforcePropertiesPanelUI();
            panel.populate(stat);
            return panel;
        }
        catch (VCSException e) {
            sLogger.log(Level.WARNING, "Failed to get properties for " + URLFileSystem.getPlatformPathName((URL)this.url));
            return new JPanel();
        }
    }
}

