/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.ide.net.URLFileSystem;
import oracle.ide.runner.RunProcess;
import oracle.jdeveloper.vcs.migrate.VCSStreamMonitor;
import oracle.jdeveloper.vcs.spi.VCSException;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceFstatResult;
import oracle.jdevimpl.vcs.perforce2.PerforceShellRunner;
import oracle.jdevimpl.vcs.perforce2.error.PerforceProcessException;
import oracle.jdevimpl.vcs.perforce2.res.PerforceArb;
import oracle.jdevimpl.vcs.perforce2.util.PerforceUtil;

public final class PerforceGetStatus {
    public static final int CCS_DIRECTORY_VERSION = 0;
    public static final int CCS_VERSION = 1;
    public static final int CCS_VIEW_PRIVATE = 2;
    public static final int CCS_UNKNOWN = 3;
    private static final String DEPOTFILE = "depotFile";
    private static final String CLIENTFILE = "clientFile";
    private static final String MOVEDFILE = "movedFile";
    private static final String ACTION = "action";
    private static final String CHANGE = "change";
    private static final String HAVEREV = "haveRev";
    private static final String HEADREV = "headRev";
    private static final String HEADTYPE = "headType";
    private static final String HEADTIME = "headTime";
    private static final String OURLOCK = "ourLock";
    private static final String UNRESOLVED = "unresolved";
    private static final String ACTIONOWNER = "actionOwner";
    private static final String OTHEROPEN = "otherOpen";
    private static final String OTHERACTION = "otherAction";
    private static final String HEADACTION = "headAction";

    private PerforceGetStatus() {
    }

    public static List fstat(PerforceConnectionProfile connect, URL parent, List files) throws VCSException {
        PerforceShellRunner fstat = new PerforceShellRunner();
        fstat.setConnection(connect);
        fstat.setCmdArray(new String[]{"-s", "fstat"});
        FstatMonitor monitor = new FstatMonitor();
        fstat.setOptionDirURL(parent);
        fstat.setFiles(files);
        fstat.setQuiet(true);
        fstat.addOutputMonitor(monitor);
        try {
            fstat.exec();
        }
        catch (Exception e) {
            throw new PerforceProcessException(PerforceArb.get("PERFORCE_COMMAND_TITLE"), PerforceArb.get("PERFORCE_COMMAND_FAILED_STATUS"), e.getMessage());
        }
        List results = monitor.getResults();
        if (results == null) {
            throw new PerforceProcessException(PerforceArb.get("PERFORCE_COMMAND_TITLE"), PerforceArb.get("PERFORCE_COMMAND_FAILED_STATUS"), fstat.getErrorText());
        }
        return results;
    }

    public static PerforceFstatResult[] fstat(PerforceConnectionProfile connect, List<String> files) throws VCSException {
        PerforceFstatResult[] fresult = new PerforceFstatResult[files.size()];
        PerforceShellRunner fstat = new PerforceShellRunner();
        fstat.setConnection(connect);
        fstat.setCmdArray(new String[]{"-s", "fstat"});
        FstatMonitor monitor = new FstatMonitor();
        fstat.setFiles(files);
        fstat.setQuiet(true);
        fstat.addOutputMonitor(monitor);
        try {
            fstat.exec();
        }
        catch (Exception e) {
            throw new PerforceProcessException(PerforceArb.get("PERFORCE_COMMAND_TITLE"), PerforceArb.get("PERFORCE_COMMAND_FAILED_STATUS"), e.getMessage());
        }
        List results = monitor.getResults();
        if (results == null) {
            throw new PerforceProcessException(PerforceArb.get("PERFORCE_COMMAND_TITLE"), PerforceArb.get("PERFORCE_COMMAND_FAILED_STATUS"), fstat.getErrorText());
        }
        Iterator it = results.iterator();
        int pos = 0;
        while (it.hasNext()) {
            if (pos == -1) {
                throw new PerforceProcessException(PerforceArb.get("PERFORCE_COMMAND_TITLE"), PerforceArb.get("PERFORCE_COMMAND_FAILED_STATUS"), "");
            }
            fresult[pos] = (PerforceFstatResult)it.next();
            ++pos;
        }
        return fresult;
    }

    public static PerforceFstatResult[] fstat(PerforceConnectionProfile connect, URL[] urls) throws VCSException {
        ArrayList<String> files = new ArrayList<String>(urls.length);
        for (int u = 0; u < urls.length; ++u) {
            if (urls[u] == null) continue;
            files.add(PerforceUtil.convertToAscii(URLFileSystem.getPlatformPathName((URL)urls[u])));
        }
        PerforceFstatResult[] stat = PerforceGetStatus.fstat(connect, files);
        return stat;
    }

    public static PerforceFstatResult fstat(PerforceConnectionProfile connect, URL parent, String file) throws VCSException {
        PerforceShellRunner runner = new PerforceShellRunner();
        runner.setOptionDirURL(parent);
        return PerforceGetStatus.fstat(connect, runner, file);
    }

    public static PerforceFstatResult fstat(PerforceConnectionProfile connect, String path) throws VCSException {
        PerforceShellRunner runner = new PerforceShellRunner();
        return PerforceGetStatus.fstat(connect, runner, PerforceUtil.convertToAscii(path));
    }

    private static PerforceFstatResult fstat(PerforceConnectionProfile connect, PerforceShellRunner runner, String path) throws VCSException {
        runner.setConnection(connect);
        runner.setCmdArray(new String[]{"-s", "fstat"});
        ArrayList<String> options = new ArrayList<String>();
        options.add(path);
        runner.setFiles(options);
        FstatMonitor monitor = new FstatMonitor();
        runner.setQuiet(false);
        runner.addOutputMonitor(monitor);
        try {
            runner.exec();
        }
        catch (Exception e) {
            throw new PerforceProcessException(PerforceArb.get("PERFORCE_COMMAND_TITLE"), PerforceArb.get("PERFORCE_COMMAND_FAILED_STATUS"), e.getMessage());
        }
        PerforceFstatResult result = monitor.getResult();
        if (result == null) {
            throw new PerforceProcessException(PerforceArb.get("PERFORCE_COMMAND_TITLE"), PerforceArb.get("PERFORCE_COMMAND_FAILED_STATUS"), runner.getErrorText());
        }
        result.setOutputText(runner.getOutputText());
        return result;
    }

    private static void setFstatResult(PerforceFstatResult result, String name, String value) {
        if (result != null) {
            if (name.equals(DEPOTFILE)) {
                result.setDepotFile(value);
            }
            if (name.equals(CLIENTFILE)) {
                result.setClientFile(value);
            }
            if (name.equals(MOVEDFILE)) {
                result.setMovedFile(value);
            } else if (name.equals(ACTION)) {
                result.setAction(value);
            } else if (name.equals(CHANGE)) {
                result.setChangelist(value);
            } else if (name.equals(HAVEREV)) {
                try {
                    result.setHaveRev(value);
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (name.equals(HEADREV)) {
                try {
                    result.setHeadRev(value);
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (name.equals(HEADTYPE)) {
                result.setHeadType(value);
            } else if (name.equals(HEADTIME)) {
                try {
                    result.setHeadTime(Long.parseLong(value));
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (name.equals(HEADACTION)) {
                result.setHeadAction(value);
            } else if (name.equals(OURLOCK)) {
                result.setLocked(true);
            } else if (name.equals(UNRESOLVED)) {
                result.setUnresolved(true);
            } else if (name.equals(ACTIONOWNER)) {
                result.setActionOwner(value);
            } else if (name.startsWith(OTHEROPEN) && name.length() > OTHEROPEN.length()) {
                String identifier = name.substring(OTHEROPEN.length());
                result.setOtherOpen(value, identifier);
            } else if (name.startsWith(OTHERACTION) && name.length() > OTHERACTION.length()) {
                String identifier = name.substring(OTHERACTION.length());
                result.setOtherAction(value, identifier);
            }
        }
    }

    private static final class FstatMonitor
    extends VCSStreamMonitor {
        private ArrayList results = new ArrayList();
        private PerforceFstatResult result = null;

        private FstatMonitor() {
        }

        public PerforceFstatResult getResult() {
            if (this.results.size() > 0) {
                return (PerforceFstatResult)this.results.get(0);
            }
            return null;
        }

        public List getResults() {
            return this.results;
        }

        protected final void streamLine(String line, RunProcess process) {
            int colon = line.indexOf(58);
            if (colon != -1) {
                String type = line.substring(0, colon);
                if (type.equals("error")) {
                    this.result = new PerforceFstatResult();
                    if (line.trim().endsWith("no such file(s).")) {
                        this.result.setNotVersioned(true);
                    } else {
                        this.result.setNotUnderRoot(true);
                    }
                    this.results.add(this.result);
                } else {
                    String value;
                    String name;
                    String remainder = line.substring(colon + 1).trim();
                    int space = remainder.indexOf(32);
                    if (space != -1) {
                        name = remainder.substring(0, space);
                        value = remainder.substring(space + 1).trim();
                    } else {
                        name = remainder;
                        value = null;
                    }
                    if (name.equals(PerforceGetStatus.DEPOTFILE)) {
                        this.result = new PerforceFstatResult();
                        this.results.add(this.result);
                    }
                    PerforceGetStatus.setFstatResult(this.result, name, value);
                }
            }
        }
    }
}

