/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.config.Preferences;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfileRegistry;
import oracle.jdeveloper.vcs.spi.VCSExtension;
import oracle.jdeveloper.vcs.spi.VCSPreferences;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.spi.VCSStatusFilter;
import oracle.jdeveloper.vcs.spi.VCSURLFileSystemHelper;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionManager;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceDepotOpenedCache;
import oracle.jdevimpl.vcs.perforce2.PerforceProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceShellRunner;
import oracle.jdevimpl.vcs.perforce2.error.PerforceException;
import oracle.jdevimpl.vcs.perforce2.res.PerforceArb;
import oracle.jdevimpl.vcs.perforce2.util.PerforceUtil;

public class PerforceFileURLFileSystemHelper
extends VCSURLFileSystemHelper {
    private static final String MOVE_TEMP_EXTENSION = "_move";
    private static final Logger sLogger = PerforceProfile.getQualifiedLogger(PerforceFileURLFileSystemHelper.class.getName());
    private VCSStatusFilter openFilter;

    public PerforceFileURLFileSystemHelper() {
        super(URLFileSystem.findHelper((String)"file"), (VCSExtension)VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.perforce"));
    }

    private VCSStatusFilter getOpenFilter() {
        if (this.openFilter == null) {
            VCSProfile profile = VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.perforce");
            this.openFilter = profile.getStatusFilter("oracle.jdeveloper.perforce2.filter.status.OPEN");
        }
        return this.openFilter;
    }

    protected boolean deleteImpl(URL url) {
        VCSStatus status;
        VCSProfile profile = VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.perforce");
        if (profile == null || !"oracle.jdeveloper.perforce".equals(profile.getID())) {
            return false;
        }
        try {
            status = (VCSStatus)profile.getPolicyStatusCache().get(url);
        }
        catch (Exception e) {
            return super.deleteImpl(url);
        }
        if (!status.isVersioned()) {
            return super.deleteImpl(url);
        }
        try {
            URL parent;
            PerforceConnectionProfile connect = PerforceConnectionManager.getInstance().getConnectionProfile(url);
            String file = PerforceUtil.convertToAscii(this.getPlatformPathName(url));
            boolean openEdit = this.getOpenFilter().accept(status);
            if (openEdit) {
                String changeLst = PerforceUtil.getChangelistNo(connect, url);
                this.revertFile(connect, file, changeLst);
            }
            if ((parent = this.getParent(url)) == null) {
                return false;
            }
            PerforceShellRunner runner = new PerforceShellRunner();
            runner.setConnection(connect);
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add("delete");
            runner.setFiles(Collections.singletonList(file));
            runner.setCmdList(cmd);
            runner.setQuiet(false);
            runner.exec();
            if (runner.getExitCode() == null || runner.getExitCode() != 0) {
                sLogger.warning("Failed to delete file " + URLFileSystem.getPlatformPathName((URL)url));
                sLogger.warning("Caused by " + runner.getErrorText());
                return false;
            }
            sLogger.log(Level.INFO, "Deleted " + file);
            profile.getPolicyStatusCache().clear(url);
            PerforceDepotOpenedCache.getInstance().clear(connect);
            return true;
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
            return false;
        }
    }

    protected boolean renameToImpl(URL oldUrl, URL newUrl) {
        VCSStatus status;
        VCSProfile profile = VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.perforce");
        try {
            status = (VCSStatus)profile.getPolicyStatusCache().get(oldUrl);
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
            return super.renameToImpl(oldUrl, newUrl);
        }
        if (!status.isVersioned()) {
            return super.renameToImpl(oldUrl, newUrl);
        }
        try {
            URL oldUrlParent = this.getParent(oldUrl);
            URL newUrlParent = this.getParent(newUrl);
            if (oldUrlParent == null || !this.exists(oldUrl)) {
                return false;
            }
            if (this.exists(newUrl) && !this.equals(oldUrl, newUrl)) {
                return false;
            }
            if (newUrlParent == null || !this.mkdirs(newUrlParent)) {
                return false;
            }
            boolean urlsEqualIgnoreCase = newUrl.toString().equalsIgnoreCase(oldUrl.toString());
            PerforceConnectionProfile connect = PerforceConnectionManager.getInstance().getConnectionProfile(oldUrl);
            boolean openEdit = this.getOpenFilter().accept(status);
            if (!openEdit) {
                this.setReadWrite(connect, profile, oldUrl);
            }
            String changeLst = PerforceUtil.getChangelistNo(connect, oldUrl);
            if (this.exists(newUrl) && urlsEqualIgnoreCase) {
                URL oldParentUrl = this.getParent(oldUrl);
                URL tempMoveUrl = URLFactory.newURL((URL)oldParentUrl, (String)(this.getFileName(oldUrl) + MOVE_TEMP_EXTENSION));
                if (!this.moveFileImpl(connect, profile, oldUrl, tempMoveUrl, changeLst, openEdit)) {
                    return false;
                }
                oldUrl = tempMoveUrl;
            }
            return this.moveFileImpl(connect, profile, oldUrl, newUrl, changeLst, openEdit);
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
            return false;
        }
    }

    protected boolean setReadWrite(URL url) {
        VCSStatus status;
        VCSProfile profile = VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.perforce");
        if (!VCSPreferences.getInstance((PropertyStorage)Preferences.getPreferences(), (String)"oracle.jdeveloper.perforce").getAutoCheckouts()) {
            return super.setReadWrite(url);
        }
        try {
            status = (VCSStatus)profile.getPolicyStatusCache().get(url);
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
            return super.setReadWrite(url);
        }
        if (!status.isVersioned()) {
            return super.setReadWrite(url);
        }
        try {
            PerforceConnectionProfile connect = PerforceConnectionManager.getInstance().getConnectionProfile(url);
            return this.setReadWrite(connect, profile, url);
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "Failed to make writable", e);
            return false;
        }
    }

    private boolean setReadWrite(PerforceConnectionProfile connect, VCSProfile profile, URL url) throws Exception {
        PerforceShellRunner runner = new PerforceShellRunner();
        runner.setConnection(connect);
        runner.setFiles(Collections.singletonList(PerforceUtil.convertToAscii(URLFileSystem.getPlatformPathName((URL)url))));
        runner.setCommand("edit");
        runner.setQuiet(false);
        runner.exec();
        if (runner.getExitCode() == null || runner.getExitCode() != 0) {
            return false;
        }
        profile.getPolicyStatusCache().clear(url);
        return !URLFileSystem.isReadOnly((URL)url);
    }

    private boolean moveFileImpl(PerforceConnectionProfile connect, VCSProfile profile, URL oldUrl, URL newUrl, String changelistNo, boolean openEdit) throws Exception {
        sLogger.log(Level.INFO, " move " + oldUrl.getPath() + " -> " + newUrl.getPath());
        PerforceShellRunner runner = new PerforceShellRunner();
        ArrayList<String> cmds = new ArrayList<String>(3);
        cmds.add("move");
        cmds.add("-c");
        cmds.add(changelistNo);
        runner.setConnection(connect);
        runner.setCmdList(cmds);
        runner.setQuiet(true);
        runner.setFiles(Arrays.asList(PerforceUtil.convertToAscii(URLFileSystem.getPlatformPathName((URL)oldUrl)), PerforceUtil.convertToAscii(URLFileSystem.getPlatformPathName((URL)newUrl))));
        runner.exec();
        if (runner.getExitCode() == null || runner.getExitCode() != 0 || !runner.getErrorText().isEmpty()) {
            sLogger.log(Level.WARNING, runner.getErrorText());
            throw new PerforceException(PerforceArb.get("ERROR_RENAME_TITLE"), runner.getErrorText());
        }
        profile.getPolicyStatusCache().clear(oldUrl);
        return true;
    }

    private boolean integrateFiles(PerforceConnectionProfile connect, String oldFile, String newFile, String changelistNo) throws Exception {
        PerforceShellRunner runner = new PerforceShellRunner();
        ArrayList<String> cmds = new ArrayList<String>(3);
        cmds.add("integrate");
        cmds.add("-h");
        cmds.add("-c");
        cmds.add(changelistNo);
        runner.setConnection(connect);
        runner.setCmdList(cmds);
        runner.setQuiet(false);
        runner.setFiles(Arrays.asList(oldFile, newFile));
        runner.exec();
        if (runner.getExitCode() == null || runner.getExitCode() != 0) {
            Assert.println((String)runner.getErrorText());
            throw new PerforceException(PerforceArb.get("ERROR_RENAME_TITLE"), runner.getErrorText());
        }
        return true;
    }

    private boolean revertFile(PerforceConnectionProfile connect, String oldFile, String changelistNo) throws Exception {
        PerforceShellRunner runner = new PerforceShellRunner();
        ArrayList<String> cmds = new ArrayList<String>(3);
        cmds.add("revert");
        cmds.add("-c");
        cmds.add(changelistNo);
        runner.setConnection(connect);
        runner.setCmdList(cmds);
        runner.setQuiet(false);
        runner.setFiles(Arrays.asList(oldFile));
        runner.exec();
        if (runner.getExitCode() == null || runner.getExitCode() != 0) {
            Assert.println((String)runner.getErrorText());
            throw new PerforceException(PerforceArb.get("ERROR_RENAME_TITLE"), runner.getErrorText());
        }
        return true;
    }
}

