/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import oracle.ide.runner.RunProcess;
import oracle.jdeveloper.vcs.migrate.VCSStreamMonitor;
import oracle.jdevimpl.vcs.perforce2.DepotFilter;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceDepotInfo;
import oracle.jdevimpl.vcs.perforce2.PerforceProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceShellRunner;
import oracle.jdevimpl.vcs.perforce2.PerforceURLInfoCache;

public class PerforceDepotOpenedCache {
    private static PerforceDepotOpenedCache _instance = new PerforceDepotOpenedCache();
    private Map<PerforceConnectionProfile, Collection<PerforceDepotInfo>> _cacheOpenDept = new HashMap<PerforceConnectionProfile, Collection<PerforceDepotInfo>>();

    private PerforceDepotOpenedCache() {
    }

    public static PerforceDepotOpenedCache getInstance() {
        return _instance;
    }

    public void clear(PerforceConnectionProfile connect) {
        if (this._cacheOpenDept.containsKey(connect)) {
            this._cacheOpenDept.remove(connect);
        }
    }

    public Collection<PerforceDepotInfo> getOpenDepotFiles(PerforceConnectionProfile connect) {
        if (!this._cacheOpenDept.containsKey(connect)) {
            try {
                this.getOpenDepotFilesImpl(connect);
            }
            catch (IOException e) {
                return null;
            }
        }
        return this._cacheOpenDept.get(connect);
    }

    public Collection<PerforceDepotInfo> getOpenDepotFiles(PerforceConnectionProfile connect, DepotFilter filter) {
        Collection<PerforceDepotInfo> files = this.getOpenDepotFiles(connect);
        ArrayList<PerforceDepotInfo> filterFiles = new ArrayList<PerforceDepotInfo>();
        for (PerforceDepotInfo file : files) {
            if (!filter.accept(file)) continue;
            filterFiles.add(file);
        }
        return filterFiles;
    }

    private void getOpenDepotFilesImpl(PerforceConnectionProfile connect) throws IOException {
        PerforceDepotMonitor monitor = new PerforceDepotMonitor();
        PerforceShellRunner runner = new PerforceShellRunner();
        ArrayList<String> cmds = new ArrayList<String>(2);
        cmds.add("opened");
        cmds.add("-C");
        cmds.add(connect.getClient());
        runner.setCmdList(cmds);
        runner.setConnection(connect);
        runner.setQuiet(true);
        runner.addOutputMonitor(monitor);
        try {
            runner.exec();
        }
        catch (Exception ex) {
            PerforceProfile.getQualifiedLogger(PerforceURLInfoCache.class.getName()).log(Level.WARNING, "Failed get open depot files " + ex.getMessage());
        }
        this._cacheOpenDept.put(connect, monitor.getPerforceDepotInfo());
    }

    private static class PerforceDepotMonitor
    extends VCSStreamMonitor {
        private Collection<PerforceDepotInfo> _info = new ArrayList<PerforceDepotInfo>();

        private PerforceDepotMonitor() {
        }

        Collection<PerforceDepotInfo> getPerforceDepotInfo() {
            return this._info;
        }

        protected void streamLine(String line, RunProcess process) throws Exception {
            String[] sections = line.split(" - ");
            if (sections.length == 2) {
                PerforceDepotInfo clFile = new PerforceDepotInfo();
                String[] files = sections[0].split("#");
                clFile.setDepotFile(files[0]);
                String[] actions = sections[1].split(" ");
                clFile.setAction(actions[0]);
                clFile.setChangeList(actions[2]);
                this._info.add(clFile);
            }
        }
    }
}

