/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2;

import java.util.Collection;
import java.util.logging.Logger;
import oracle.ide.cmd.ExitCommand;
import oracle.ide.cmd.ShutdownHook;
import oracle.ide.explorer.ExplorerManager;
import oracle.jdeveloper.vcs.generic.VCSAddin;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionManager;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceSessionManager;
import oracle.jdevimpl.vcs.perforce2.nav.PerforceConnectionExplorer;
import oracle.jdevimpl.vcs.perforce2.res.PerforceArb;

final class PerforceAddin
extends VCSAddin {
    private static final Logger sLogger = PerforceProfile.getQualifiedLogger(PerforceProfile.class.getName());

    PerforceAddin() {
    }

    protected void initializeImpl() {
        ExplorerManager.getExplorerManager().register(PerforceConnectionProfile.class, PerforceConnectionExplorer.class, null, PerforceArb.get("NAV_CONN_EXPLORER_CAPTION"), null);
        ExitCommand.addShutdownHook((ShutdownHook)new ShutdownHook(){

            public boolean canShutdown() {
                return true;
            }

            public void shutdown() {
                try {
                    Collection<PerforceConnectionProfile> cons = PerforceConnectionManager.getInstance().list();
                    for (PerforceConnectionProfile con : cons) {
                        if (!PerforceSessionManager.getInstance().isConnected(con) || con.isAutoLogIn()) continue;
                        PerforceSessionManager.getInstance().disconnect(con, false);
                    }
                }
                catch (Exception e) {
                    sLogger.warning("Failed to logout connection on exit " + e.getMessage());
                }
            }
        });
    }
}

