/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.runner.RunProcess;
import oracle.jdeveloper.vcs.migrate.VCSStreamMonitor;
import oracle.jdeveloper.vcs.spi.VCSException;
import oracle.jdeveloper.vcs.util.VCSOperatingSystem;
import oracle.jdevimpl.vcs.perforce2.PerforceProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceShellRunner;
import oracle.jdevimpl.vcs.perforce2.error.PerforceProcessException;
import oracle.jdevimpl.vcs.perforce2.res.PerforceArb;

public class DefaultPerforceConnection {
    private static String P4PORT = "P4PORT";
    private static String P4PASSWD = "P4PASSWD";
    private static String P4USER = "P4USER";
    private static String P4CLIENT = "P4CLIENT";
    private String p4port = null;
    private String p4user = null;
    private String p4passwd = null;
    private String p4client = null;
    private static final Logger sLogger = PerforceProfile.getQualifiedLogger(DefaultPerforceConnection.class.getName());

    public DefaultPerforceConnection() {
        if (VCSOperatingSystem.isWindows()) {
            this.getEnvFromRegistry();
        } else {
            this.getEnvFromVariables();
        }
    }

    public String getName() {
        return null;
    }

    public String getUser() {
        return this.useDefault() ? this.p4user : (String)this.getProperty("p4user");
    }

    public String getPassword() {
        return this.useDefault() ? this.p4passwd : (String)this.getProperty("p4passwd");
    }

    public String getServer() {
        return this.useDefault() ? this.p4port : (String)this.getProperty("p4port");
    }

    public String getClient() {
        return this.useDefault() ? this.p4client : (String)this.getProperty("p4client");
    }

    protected final Object getProperty(String key) {
        return null;
    }

    protected final boolean useDefault() {
        Boolean useDefault = (Boolean)this.getProperty("use_default");
        return useDefault == null ? true : useDefault;
    }

    private void getEnvFromRegistry() {
        try {
            Map env = this.set();
            this.p4port = (String)env.get(P4PORT);
            this.p4user = (String)env.get(P4USER);
            this.p4passwd = (String)env.get(P4PASSWD);
            this.p4client = (String)env.get(P4CLIENT);
        }
        catch (VCSException vCSException) {
            // empty catch block
        }
    }

    private void getEnvFromVariables() {
        this.p4port = System.getenv(P4PORT);
        this.p4user = System.getenv(P4USER);
        this.p4passwd = System.getenv(P4PASSWD);
        this.p4client = System.getenv(P4CLIENT);
    }

    private Map set() throws VCSException {
        if (VCSOperatingSystem.isWindows()) {
            PerforceShellRunner set = new PerforceShellRunner();
            set.setCommand("set");
            set.setQuiet(true);
            SetMonitor monitor = new SetMonitor();
            set.addOutputMonitor(monitor);
            try {
                set.exec();
                if (set.getExitCode() != 0) {
                    throw new PerforceProcessException(PerforceArb.get("PERFORCE_CONNECTION_TITLE"), PerforceArb.get("PERFORCE_CONNECTION_FAILED"), set.getErrorText());
                }
            }
            catch (Exception e) {
                sLogger.log(Level.WARNING, "Failed to run p4 set ", e);
                throw new PerforceProcessException(PerforceArb.get("PERFORCE_CONNECTION_TITLE"), PerforceArb.get("PERFORCE_CONNECTION_FAILED"), e.getMessage());
            }
            return monitor.getResult();
        }
        return null;
    }

    private static class SetMonitor
    extends VCSStreamMonitor {
        private Map result = new HashMap();

        private SetMonitor() {
        }

        public Map getResult() {
            return this.result;
        }

        protected final void streamLine(String line, RunProcess process) {
            int equals = line.indexOf(61);
            if (equals != -1) {
                String name = line.substring(0, equals).trim();
                String remainder = line.substring(equals + 1).trim();
                StringTokenizer tokenizer = new StringTokenizer(remainder, " ");
                if (tokenizer.hasMoreTokens()) {
                    String value = tokenizer.nextToken();
                    this.result.put(name, value);
                }
            }
        }
    }
}

