/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrf.was;

import com.ibm.websphere.runtime.CustomService;
import java.io.File;
import java.util.Properties;
import oracle.as.jmx.framework.was.spi.ServerEnvironment;
import oracle.as.jmx.framework.was.spi.WASServerLifeCycleListener;
import oracle.jrf.AbstractServerPlatformSupport;
import oracle.jrf.InternalJrfUtils;
import oracle.jrf.JrfUtils;
import oracle.jrf.ServerPlatformSupport;
import oracle.jrf.ServerPlatformSupportFactory;
import oracle.jrf.ServerStartupShutdownManager;
import oracle.jrf.was.WasJRFServerLifeCycleListener;

public class WebSphereJRFCustomService
implements CustomService {
    private final String NODE_AGENT_NAME = "nodeagent";

    public void initialize(Properties arg0) throws Exception {
        this.initServerConfigDir();
        new ServerStartupShutdownManager().startup();
        AbstractServerPlatformSupport platform = (AbstractServerPlatformSupport)ServerPlatformSupportFactory.getInstance();
        platform.init();
    }

    public void shutdown() throws Exception {
        new ServerStartupShutdownManager().shutdown();
    }

    private void initServerConfigDir() throws Exception {
        ServerPlatformSupport platform = ServerPlatformSupportFactory.getInstance();
        File commonHomeDir = new File(JrfUtils.getCommonComponentsHome());
        File domainConfigDir = new File(platform.getDomainConfigDirectory());
        if (platform.getServerName().equals("dmgr") || !platform.isWebSphereND()) {
            File cellNodesDir = new File(domainConfigDir.getParent(), "nodes");
            for (File nodeDir : cellNodesDir.listFiles()) {
                if (!nodeDir.isDirectory()) continue;
                File nodeServersDir = new File(nodeDir, "servers");
                for (File serverDir : nodeServersDir.listFiles()) {
                    if (!serverDir.isDirectory() || serverDir.getName().equals("nodeagent")) continue;
                    File serverConfigDir = new File(serverDir, "fmwconfig");
                    InternalJrfUtils.copyServerConfigTemplateToServerDir(domainConfigDir, commonHomeDir, serverConfigDir);
                    InternalJrfUtils.mergeLoggersFromDir(domainConfigDir, serverConfigDir, new File(serverConfigDir, "logging.xml"));
                }
            }
            if (platform.isWebSphereND()) {
                ServerEnvironment.addServerLifeCycleListener((WASServerLifeCycleListener)new WasJRFServerLifeCycleListener(domainConfigDir, commonHomeDir), (int)0);
            }
        } else {
            File serverConfigDir = new File(platform.getServerConfigDirectory());
            InternalJrfUtils.copyServerConfigTemplateToServerDir(domainConfigDir, commonHomeDir, serverConfigDir);
        }
    }
}

