/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrf.was;

import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import java.util.ArrayList;
import java.util.List;
import javax.management.ObjectName;
import oracle.jrf.PortabilityLayerException;
import oracle.jrf.templates.Application;
import oracle.jrf.templates.EnvConfig;
import oracle.jrf.templates.JRFTemplateHelper;
import oracle.jrf.templates.Library;
import oracle.jrf.templates.NamedResource;
import oracle.jrf.templates.StartupClass;
import oracle.jrf.templates.Template;
import oracle.jrf.templates.URLProvider;
import oracle.jrf.was.WasJRFService;

public class WasJRFUtils {
    public static boolean isDmgrServer(ObjectName serverId) {
        if (serverId.toString().indexOf("/clusters") != -1) {
            return false;
        }
        return ConfigServiceHelper.getDisplayName((ObjectName)serverId).equals(WasJRFService.DMGR_SERVER);
    }

    public static boolean isOracleAdminServer(ObjectName serverId) {
        if (serverId.toString().indexOf("/clusters") != -1) {
            return false;
        }
        return ConfigServiceHelper.getDisplayName((ObjectName)serverId).equals(WasJRFService.ORACLE_ADMIN_SERVER);
    }

    public static String getCellNameFromId(ObjectName id) {
        String str = id.toString();
        int cellidx = str.indexOf("cells/");
        int nodeidx = str.indexOf("/nodes");
        return str.substring(cellidx + "cells/".length(), nodeidx);
    }

    public static String getNodeNameFromId(ObjectName id) {
        String str = id.toString();
        int nodeidx = str.indexOf("nodes/");
        int serveridx = str.indexOf("/servers");
        return str.substring(nodeidx + "nodes/".length(), serveridx);
    }

    public static String getCellNameFromClusterId(ObjectName id) {
        String str = id.toString();
        int cellidx = str.indexOf("cells/");
        int nodeidx = str.indexOf("/clusters");
        return str.substring(cellidx + "cells/".length(), nodeidx);
    }

    public static List<Library> getJRFLibrariesFromTemplate(ObjectName targetId) throws PortabilityLayerException {
        return WasJRFUtils.getJRFResourcesFromTemplate(targetId, "library");
    }

    public static List<Application> getJRFApplicationsFromTemplate(ObjectName targetId) throws PortabilityLayerException {
        return WasJRFUtils.getJRFResourcesFromTemplate(targetId, "app-deployment");
    }

    public static List<StartupClass> getJRFCustomServicesFromTemplate(ObjectName targetId) throws PortabilityLayerException {
        return WasJRFUtils.getJRFResourcesFromTemplate(targetId, "custom-service");
    }

    public static List<URLProvider> getJRFUrlProvidersFromTemplate(ObjectName targetId) throws PortabilityLayerException {
        return WasJRFUtils.getJRFResourcesFromTemplate(targetId, "url-provider");
    }

    public static List<EnvConfig> getJRFEnvConfigsFromTemplate() throws PortabilityLayerException {
        Template template = JRFTemplateHelper.getJRFTemplateForWAS();
        ArrayList<EnvConfig> envConfigs = new ArrayList<EnvConfig>();
        envConfigs.addAll(template.getEnvConfigs().values());
        for (Template subTemplate : template.getSubTemplates()) {
            envConfigs.addAll(subTemplate.getEnvConfigs().values());
        }
        return envConfigs;
    }

    private static List<? extends NamedResource> getJRFResourcesFromTemplate(ObjectName targetId, String resourceType) throws PortabilityLayerException {
        if (WasJRFUtils.isDmgrServer(targetId)) {
            return JRFTemplateHelper.getJRFDmgrResourcesFromTemplate(resourceType, JRFTemplateHelper.getJRFTemplateForWAS());
        }
        if (WasJRFUtils.isOracleAdminServer(targetId)) {
            return JRFTemplateHelper.getJRFAdminResourcesFromTemplate(resourceType, JRFTemplateHelper.getJRFTemplateForWAS());
        }
        return JRFTemplateHelper.getJRFManagedResourcesFromTemplate(resourceType, JRFTemplateHelper.getJRFTemplateForWAS());
    }
}

