/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrf;

import oracle.jrf.JRFService;
import oracle.jrf.PortabilityLayerException;
import oracle.jrf.ServerPlatformSupportFactory;
import oracle.jrf.i18n.JRFMessageBundleHelper;

public class JRFServiceFactory {
    public static JRFService getJRFService() throws PortabilityLayerException {
        try {
            if (ServerPlatformSupportFactory.getInstance().isWebLogic()) {
                return (JRFService)Class.forName("oracle.jrf.wls.WlsJRFService").newInstance();
            }
            if (ServerPlatformSupportFactory.getInstance().isWebSphere()) {
                return (JRFService)Class.forName("oracle.jrf.was.WasJRFService").newInstance();
            }
            if (ServerPlatformSupportFactory.getInstance().isJBoss()) {
                return (JRFService)Class.forName("oracle.jrf.jboss.JBossJRFService").newInstance();
            }
            throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-20028"));
        }
        catch (Exception ex) {
            throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-20026", new String[]{ServerPlatformSupportFactory.getInstance().getPlatformName()}), ex);
        }
    }
}

