/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.util.xclass;

import oracle.aurora.util.xclass.Signature;
import oracle.aurora.util.xclass.XClass;

public interface XType {
    public int kind();

    public XClass toClass();

    public XType returnType();

    public XType[] parameterTypes();

    public int dim();

    public XType elementType();

    public char typecode();

    public String signature();

    public static abstract class Abstract
    implements XType {
        public XClass toClass() {
            return null;
        }

        public XType returnType() {
            return this;
        }

        public XType[] parameterTypes() {
            return new XType[0];
        }

        public int dim() {
            return 0;
        }

        public XType elementType() {
            return this;
        }

        public String signature() {
            return Signature.toSignature(this);
        }

        public int hashCode() {
            return this.signature().hashCode();
        }

        public boolean equals(Object other) {
            boolean e = false;
            if (other instanceof XType) {
                XType oType = (XType)other;
                switch (this.kind()) {
                    case 2: {
                        e = this.typecode() == oType.typecode();
                        break;
                    }
                    case 1: {
                        e = this.dim() == oType.dim() && this.elementType().equals(oType.elementType());
                        break;
                    }
                    case 3: {
                        e = this.returnType().equals(oType.returnType());
                        XType[] params = this.parameterTypes();
                        XType[] oParams = oType.parameterTypes();
                        e = e && params.length == oParams.length;
                        for (int xParam = 0; e && xParam < params.length; ++xParam) {
                            e = e && params[xParam].equals(oParams[xParam]);
                        }
                        break;
                    }
                    case 0: {
                        XClass clazz = this.toClass();
                        XClass oClass = oType.toClass();
                        e = oClass != null && clazz.name().equals(oClass.name()) && clazz.domain().equals(oClass.domain());
                    }
                }
            }
            return e;
        }
    }
}

