/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.util;

import java.io.IOException;
import java.io.StreamTokenizer;
import oracle.aurora.util.Cursor;
import oracle.aurora.util.DynaHash;
import oracle.aurora.util.GraphWalker;
import oracle.aurora.util.Identifier;
import oracle.aurora.util.MapCursor;
import oracle.aurora.util.NodeStat;
import oracle.aurora.util.NodeTraverser;
import oracle.aurora.util.OrderedCollection;

public class TopSort {
    DynaHash nodeTable = new DynaHash(new Identifier(){

        public int hash(Object obj) {
            return System.identityHashCode(((Node)obj).userNode);
        }

        public int findHash(Object obj) {
            return System.identityHashCode(obj);
        }

        public boolean identify(Object obj1, Object obj2) {
            return ((Node)obj1).userNode == ((Node)obj2).userNode;
        }

        public boolean findIdentify(Object obj, Object find) {
            return ((Node)obj).userNode == find;
        }
    });
    OrderedCollection allNodes = new OrderedCollection();
    OrderedCollection sorted;
    GraphWalker walker;

    public void addEdge(Object from, Object to) {
        Node fromNode = this.lookup(from);
        Node toNode = this.lookup(to);
        fromNode.targets.append(toNode);
    }

    public Cursor enumerate() {
        if (this.sorted == null) {
            this.sort();
        }
        return new MapCursor(this.sorted.enumerate()){

            public Object transform(Object obj) {
                Node n = (Node)obj;
                return new MapCursor(n.members.enumerate()){

                    public Object transform(Object obj) {
                        Node m = (Node)obj;
                        return m.userNode;
                    }
                };
            }
        };
    }

    public void sort() {
        this.initWalker();
        this.doNumber();
        this.doUpOne();
        this.doSccEntry();
        this.doCount();
        this.doSorted();
    }

    Node lookup(Object userNode) {
        Node result = (Node)this.nodeTable.find(userNode);
        if (result == null) {
            result = new Node(userNode);
            this.nodeTable.replace(result);
            this.allNodes.append(result);
        }
        return result;
    }

    void initWalker() {
        this.walker = new GraphWalker(false, null, null);
    }

    void walk(Actor t) {
        this.walker.reset();
        Cursor nodes = this.allNodes.enumerate();
        while (nodes.next()) {
            Node n = (Node)nodes.get();
            if (!t.reset(n)) continue;
            this.walker.walkRoot(n, t, false);
            while (this.walker.next()) {
                this.walker.get();
            }
        }
    }

    NodeStat nodeStat(Node n) {
        return this.walker.getNodeStat(n);
    }

    private void doNumber() {
        this.walk(new Actor(){
            int nextNumber;

            protected void prefix(Node n, NodeStat s) {
                n.number = this.nextNumber++;
            }
        });
    }

    private void doUpOne() {
        this.walk(new Actor(){

            public boolean reset(Node n) {
                return true;
            }

            protected void prefix(Node n) {
                n.upOne = n;
            }

            protected void suffix(Node n) {
                Node best = n;
                Cursor targets = n.targets.enumerate();
                while (targets.next()) {
                    Node tNode = (Node)targets.get();
                    Node upCandidate = tNode.upOne;
                    if (TopSort.this.nodeStat((Node)upCandidate).status != 2 || upCandidate.number >= best.number) continue;
                    best = upCandidate;
                }
                n.upOne = best;
            }
        });
    }

    private void doSccEntry() {
        this.walk(new Actor(){

            protected void prefix(Node n) {
                Node entry;
                if (n.upOne == n) {
                    entry = n;
                    n.members = new OrderedCollection();
                } else {
                    entry = n.upOne.sccEntry;
                }
                n.sccEntry = entry;
                entry.members.append(n);
            }
        });
    }

    private void doCount() {
        this.walk(new Actor(){

            protected void suffix(Node n) {
                Cursor targets = n.targets.enumerate();
                while (targets.next()) {
                    Node targetEntry = ((Node)targets.get()).sccEntry;
                    if (targetEntry == n.sccEntry) continue;
                    ++targetEntry.count;
                }
            }
        });
        Cursor nodes = this.allNodes.enumerate();
        while (nodes.next()) {
            Node node = (Node)nodes.get();
            if (!node.isSccEntry()) continue;
        }
    }

    public void doSorted() {
        this.sorted = new OrderedCollection();
        OrderedCollection roots = new OrderedCollection();
        Cursor nodes = this.allNodes.enumerate();
        while (nodes.next()) {
            Node node = (Node)nodes.get();
            if (!node.isSccEntry() || node.count != 0) continue;
            this.sorted.append(node);
            roots.append(node);
        }
        while (!roots.isEmpty()) {
            Node root = (Node)roots.pop();
            Cursor members = root.members.enumerate();
            while (members.next()) {
                Node member = (Node)members.get();
                Cursor targets = member.targets.enumerate();
                while (targets.next()) {
                    Node targetEntry = ((Node)targets.get()).sccEntry;
                    if (targetEntry == root) continue;
                    --targetEntry.count;
                    if (targetEntry.count != 0) continue;
                    roots.append(targetEntry);
                    this.sorted.append(targetEntry);
                }
            }
        }
    }

    public static void main(String[] argv) throws IOException {
        TopSort ts = new TopSort();
        StreamTokenizer tk = new StreamTokenizer(System.in);
        while (tk.nextToken() != -1) {
            String from = tk.sval.intern();
            tk.nextToken();
            String to = tk.sval.intern();
            ts.addEdge(from, to);
        }
        Cursor components = ts.enumerate();
        while (components.next()) {
            Cursor m = (Cursor)components.get();
            while (m.next()) {
                System.out.print(m.get());
                System.out.print(" ");
            }
            System.out.println();
        }
    }

    class Node {
        Object userNode;
        OrderedCollection targets = new OrderedCollection();
        int number;
        Node upOne;
        Node sccEntry;
        OrderedCollection members;
        int count;

        boolean isSccEntry() {
            return this.sccEntry == this;
        }

        public Node(Object userNode) {
            this.userNode = userNode;
        }

        public String toString() {
            return "Node[ " + this.userNode + " ]";
        }
    }

    class Actor
    implements NodeTraverser {
        Actor() {
        }

        public boolean reset(Node root) {
            return true;
        }

        public Cursor beginTraverse(Object node, NodeStat status) {
            this.prefix((Node)node, status);
            return ((Node)node).targets.enumerate();
        }

        protected void prefix(Node node, NodeStat status) {
            this.prefix(node);
        }

        protected void prefix(Node node) {
        }

        public void endTraverse(Object node, NodeStat status) {
            this.suffix((Node)node, status);
        }

        protected void suffix(Node node, NodeStat status) {
            this.suffix(node);
        }

        protected void suffix(Node node) {
        }

        public int scanMode(Object node) {
            return 0;
        }
    }
}

