/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.server.tools.loadjava;

import java.util.StringTokenizer;
import java.util.Vector;
import oracle.aurora.server.tools.loadjava.LoadJava;
import oracle.aurora.server.tools.loadjava.MkMsg;
import oracle.aurora.server.tools.loadjava.ToolsError;
import oracle.aurora.server.tools.loadjava.ToolsException;
import oracle.aurora.server.tools.loadjava.ToolsMessage;
import oracle.aurora.util.msg.Msg;

public class LoadJavaMain {
    private Msg mkMsg = MkMsg.mkMsg;
    private boolean successFlag = true;
    private Exception exitException = null;

    public static void main(String[] args) {
        String[] r;
        String res;
        String passwd;
        int len = args.length;
        String user = System.getenv("LJUSER");
        if (user != null) {
            len += 2;
        }
        if ((passwd = System.getenv("LJPASS")) != null) {
            len += 2;
        }
        if ((res = System.getenv("RESOLVER")) != null) {
            len += 2;
        }
        int pos = 0;
        String[] allargs = new String[len];
        if (user != null) {
            System.arraycopy(user.split(" "), 0, allargs, pos, 2);
            pos += 2;
        }
        if (passwd != null) {
            r = passwd.split(" ");
            if (r[1].equals("\"\"")) {
                r[1] = "";
            }
            System.arraycopy(r, 0, allargs, pos, 2);
            pos += 2;
        }
        if (res != null) {
            r = new String[]{res.substring(0, res.indexOf(" ")), res.substring(res.indexOf(" ") + 1)};
            r[1] = r[1].replace("'", "");
            System.arraycopy(r, 0, allargs, pos, 2);
            pos += 2;
        }
        System.arraycopy(args, 0, allargs, pos, args.length);
        LoadJavaMain ljm = new LoadJavaMain();
        ljm.run(allargs);
        if (!ljm.successFlag) {
            System.exit(1);
        }
    }

    public static void serverMain(String args) {
        String resolver = null;
        int ridx = 0;
        ridx = args.indexOf("-resolver");
        if (ridx >= 0) {
            String tmp = null;
            int fpidx = args.indexOf("(");
            int lpidx = args.lastIndexOf(")");
            resolver = args.substring(fpidx, lpidx + 1);
            if (ridx == 0) {
                ++ridx;
            }
            args = tmp = args.substring(0, ridx - 1) + args.substring(lpidx + 1);
        }
        LoadJavaMain.serverMain(args, resolver);
    }

    public static void serverMain(String args, String resolver) {
        LoadJavaMain.serverMain(args, resolver, null);
    }

    public static void serverMain(String argString, String resolver, int[] success) {
        LoadJavaMain ljm = new LoadJavaMain();
        if (argString == null) {
            throw new IllegalArgumentException("Null argument string");
        }
        Vector<String> argv = new Vector<String>();
        argv.addElement("-kprb");
        if (resolver != null) {
            argv.addElement("-resolver");
            argv.addElement(resolver);
        }
        StringTokenizer tokens = new StringTokenizer(argString);
        while (tokens.hasMoreTokens()) {
            argv.addElement(tokens.nextToken());
        }
        Object[] args = new String[argv.size()];
        argv.copyInto(args);
        ljm.run((String[])args);
        if (success != null) {
            success[0] = ljm.successFlag ? 1 : 0;
        } else if (!ljm.successFlag) {
            String msg;
            boolean messageOnly = false;
            if (ljm.exitException == null) {
                msg = "Error during loadjava";
            } else {
                String emsg = ljm.exitException.getMessage();
                if (emsg.equals("help")) {
                    msg = "loadjava help message";
                    messageOnly = true;
                } else if (emsg.equals("usage")) {
                    msg = "loadjava usage message";
                    messageOnly = true;
                } else {
                    msg = emsg.equals("usage error") ? "loadjava  usage error" : "\nError during loadjava: " + emsg;
                }
            }
            msg = msg + ".\nCheck trace file for details";
            throw messageOnly ? new ToolsMessage(msg) : new ToolsError(msg);
        }
    }

    void run(String[] argv) {
        LoadJava lj = new LoadJava();
        try {
            lj.command(argv);
        }
        catch (ToolsException ex) {
            System.err.println("exiting  : " + ex.getMessage());
            if (lj.getGenericOpts().getBoolean("-debug") && ex.getChain() != null) {
                ex.getChain().printStackTrace(System.err);
            }
            this.successFlag = false;
            this.exitException = ex;
        }
        catch (ToolsError ex) {
            System.err.println("exiting  : " + ex.getMessage());
            this.successFlag = false;
            this.exitException = ex;
        }
    }

    public LoadJava parseArgs(String[] argv) throws ToolsException {
        LoadJava lj = new LoadJava();
        String[] unrecognized = lj.parseArgs(argv);
        for (int xUnrec = 0; xUnrec < unrecognized.length; ++xUnrec) {
            String opt = unrecognized[xUnrec];
            if (opt == null || opt.length() == 0) continue;
            if (opt.charAt(0) == '-') {
                lj.err(this.mkMsg.m("unrecognized option{0}", opt));
                continue;
            }
            lj.addFileName(opt);
        }
        return lj;
    }
}

