/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.server.tools.loadjava;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.aurora.security.JServerPermission;
import oracle.aurora.util.IOCopy;
import oracle.aurora.vm.EnvironmentSpecific;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.internal.OracleCallableStatement;
import oracle.sql.BLOB;

public class Deploy {
    public static final int BUFFER_SIZE = 32000;
    private static Connection conn;
    private static DeployFile file;
    private static JServerPermission deployPermission;

    private static Connection getConnection() throws SQLException {
        if (conn == null) {
            conn = new OracleDriver().defaultConnection();
        }
        return conn;
    }

    static void checkPermission() {
        SecurityManager sm = System.getSecurityManager();
        if (deployPermission == null) {
            deployPermission = new JServerPermission("Deploy");
        }
        if (sm != null) {
            sm.checkPermission((Permission)deployPermission);
        }
    }

    static String act(PrivilegedExceptionAction action) throws Exception {
        Deploy.checkPermission();
        try {
            Object r = AccessController.doPrivileged(action);
            String s = r == null ? null : r.toString();
            return s;
        }
        catch (PrivilegedActionException ex) {
            throw ex.getException();
        }
    }

    public static String invoke(final String schemaName, final String className) throws Exception {
        String result = Deploy.act(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                String s = null;
                Class c = schemaName == null ? EnvironmentSpecific.classForNameAndSchema(className, -2) : EnvironmentSpecific.classForNameAndSchema(className, schemaName);
                Object r = c.newInstance();
                if (r instanceof Runnable) {
                    ((Runnable)r).run();
                } else if (r instanceof Action) {
                    s = ((Action)r).act();
                }
                return s;
            }
        });
        return result;
    }

    public static void open(final String filename, final BLOB[] blob) throws Exception {
        Deploy.act(new PrivilegedExceptionAction(){

            public Object run() throws SQLException, IOException {
                try {
                    file = new DeployFile(filename, blob);
                    return null;
                }
                catch (SQLException sql) {
                    sql.printStackTrace();
                    throw sql;
                }
                catch (IOException io) {
                    io.printStackTrace();
                    throw io;
                }
            }
        });
    }

    public static void copy(final BLOB blobIn) throws Exception {
        Deploy.act(new PrivilegedExceptionAction(){

            public Object run() throws SQLException, IOException {
                file.copy(blobIn);
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeBlob(byte[] buffer, int n, BLOB blob) throws SQLException, IOException {
        OutputStream blobOut = blob.getBinaryOutputStream();
        try {
            int hi = n >> 8 & 0xFF;
            blobOut.write(hi);
            int lo = n & 0xFF;
            blobOut.write(lo);
            blobOut.write(buffer, 0, n);
        }
        finally {
            blobOut.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int readBlob(byte[] buffer, BLOB blob) throws SQLException, IOException {
        int n = 0;
        InputStream blobIn = blob.getBinaryStream();
        try {
            int hi = blobIn.read();
            int lo = blobIn.read();
            if (hi < 0 || lo < 0) {
                throw new IOException("BLOB stream ended prematurely");
            }
            n = (hi << 8) + lo;
            blobIn.read(buffer, 0, n);
        }
        finally {
            blobIn.close();
        }
        return n;
    }

    public static void main(String[] argv) throws Exception {
        FileInputStream in = new FileInputStream(argv[0]);
        String outputFile = argv[1];
        BLOB[] out = new BLOB[1];
        Deploy.open(outputFile, out);
        BLOB blob = out[0];
        byte[] buffer = new byte[32000];
        int n = ((InputStream)in).read(buffer);
        while (n > 0) {
            Deploy.writeBlob(buffer, n, blob);
            n = ((InputStream)in).read(buffer);
        }
        Deploy.copy(blob);
        ((InputStream)in).close();
    }

    static class DeployFile {
        String filename;
        byte[] buffer = new byte[32000];

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        DeployFile(String filename, BLOB[] blob) throws SQLException, IOException {
            this.filename = filename;
            OracleCallableStatement stmt = null;
            try {
                String callString = "{ call dbms_lob.createtemporary(?, TRUE) }";
                stmt = (OracleCallableStatement)Deploy.getConnection().prepareCall(callString);
                stmt.registerOutParameter(1, 2004);
                stmt.execute();
                blob[0] = stmt.getBLOB(1);
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }

        FileOutputStream openFile(String filename) throws IOException {
            File oracleHome = new File(System.getProperty("oracle.aurora.rdbms.oracle_home"));
            File deploy = new File(oracleHome, "javavm");
            deploy = new File(deploy, "deploy");
            deploy.mkdir();
            File destination = new File(deploy, filename);
            FileOutputStream fileOut = new FileOutputStream(destination);
            return fileOut;
        }

        void closeBlob(BLOB tempBlob) throws SQLException {
            OracleCallableStatement stmt = null;
            try {
                String callString = "{ call dbms_lob.freetemporary(?) }";
                stmt = (OracleCallableStatement)conn.prepareCall(callString);
                stmt.setBLOB(1, tempBlob);
                stmt.execute();
            }
            catch (SQLException sql) {
                sql.printStackTrace();
                throw sql;
            }
            finally {
                tempBlob = null;
                if (stmt != null) {
                    stmt.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void copy(BLOB blobIn) throws SQLException, IOException {
            FileOutputStream out = null;
            InputStream in = null;
            try {
                out = this.openFile(this.filename);
                in = blobIn.getBinaryStream();
                new IOCopy().copy(out, in);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ignore) {}
                }
                if (out != null) {
                    try {
                        ((OutputStream)out).close();
                    }
                    catch (IOException ignore) {}
                }
            }
        }
    }

    public static interface Action {
        public String act() throws Exception;
    }
}

