/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.server.tools.loadjava;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import oracle.aurora.server.tools.loadjava.CommonClassObject;
import oracle.aurora.server.tools.loadjava.CommonSourceObject;
import oracle.aurora.server.tools.loadjava.LoadJavaOptions;
import oracle.aurora.server.tools.loadjava.LoadJavaState;
import oracle.aurora.server.tools.loadjava.MkMsg;
import oracle.aurora.server.tools.loadjava.SchemaObject;
import oracle.aurora.util.IOCopy;
import oracle.aurora.util.msg.Msg;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleConnection;
import oracle.sql.BLOB;

class ClientSchemaObject
extends SchemaObject {
    private Msg mkMsg = MkMsg.mkMsg;
    protected String shortname = null;
    protected String name = null;
    private CommonSourceObject source_helper;
    private CommonClassObject class_helper;
    private String schema;

    ClientSchemaObject(LoadJavaState state, LoadJavaOptions opt, int type, InputStream in, String externalName) {
        super(state, opt, type, in, externalName);
        switch (type) {
            case 29: {
                if (in != null) break;
                this.name = externalName;
                break;
            }
            case 1002: {
                try {
                    this.schema = this.getSchema();
                    if (this.schema == null) {
                        this.schema = ((OracleConnection)this.getState().getConnection()).getUserName();
                    }
                }
                catch (SQLException sqe) {
                    this.err(sqe, this.mkMsg.m("Error setting schema"));
                }
                this.path = externalName;
                this.fullJarname = this.getExternalName();
                if (!this.fullJarname.startsWith("/")) break;
                this.fullJarname = "ROOT" + this.fullJarname;
                break;
            }
            case 1001: {
                this.name = externalName;
                break;
            }
        }
    }

    CommonSourceObject getSourceHelper() {
        if (this.source_helper == null) {
            this.source_helper = new CommonSourceObject(this);
        }
        return this.source_helper;
    }

    CommonClassObject getClassHelper() {
        if (this.class_helper == null) {
            this.class_helper = new CommonClassObject(this);
        }
        return this.class_helper;
    }

    boolean deleteMD5() {
        switch (this.type) {
            case 28: 
            case 29: 
            case 30: {
                return this.getState().MD5TableIsObsolete() || this.getHelper().deleteMD5(this);
            }
            case 1002: {
                return false;
            }
        }
        return true;
    }

    boolean updateMD5(boolean ok) {
        switch (this.type) {
            case 28: 
            case 29: 
            case 30: {
                byte[] newMD5;
                if (this.getState().MD5TableIsObsolete()) break;
                this.deleteMD5();
                if (!ok || (newMD5 = this.getNewMD5()) == null) break;
                ok = this.getHelper().updateMD5(this, newMD5);
                break;
            }
            case 1002: {
                ok = false;
                break;
            }
            default: {
                ok = true;
            }
        }
        return ok;
    }

    byte[] getOldMD5() {
        if (this.type == 29 || this.type == 30 || this.type == 28) {
            return this.getState().getOldMD5(this.getNameForMD5Table(), this.getSchema(), this.type);
        }
        return null;
    }

    boolean shortnameKnown() {
        return this.shortname != null;
    }

    void setShortname(String s) {
        this.shortname = s;
    }

    String getShortname() {
        if (this.shortname == null) {
            String longname;
            String s = longname = this.type == 1002 ? this.fullJarname : this.getPerhapsJarQualifiedName();
            try {
                PreparedStatement stmt = this.getState().getShortFromLongnameStmt();
                stmt.setString(1, longname);
                ResultSet rs = stmt.executeQuery();
                if (rs.next()) {
                    s = rs.getString(1);
                }
            }
            catch (SQLException e) {
                this.err(e, this.mkMsg.m("computing shortname of {0}", longname));
            }
            this.shortname = s;
        }
        return this.shortname;
    }

    public int status() {
        if (this.type == 29 || this.type == 30 || this.type == 28) {
            String classname = this.getName();
            int category = this.type;
            int result = 0;
            String when = this.mkMsg.m("checking status of {0}", classname);
            if (classname == null) {
                return 0;
            }
            PreparedStatement statusStmt = null;
            try {
                String shortName = this.getShortname();
                String typeString = null;
                switch (category) {
                    case 29: {
                        typeString = "JAVA CLASS";
                        break;
                    }
                    case 28: {
                        typeString = "JAVA SOURCE";
                        break;
                    }
                    case 30: {
                        typeString = "JAVA RESOURCE";
                        break;
                    }
                    default: {
                        typeString = null;
                    }
                }
                if (typeString == null) {
                    result = 3;
                } else {
                    String status;
                    String schema = this.getSchema();
                    if (schema == null) {
                        statusStmt = this.getState().getUserStatusStmt();
                        statusStmt.setString(1, typeString);
                        statusStmt.setString(2, shortName);
                    } else {
                        statusStmt = this.getState().getAllStatusStmt();
                        statusStmt.setString(1, typeString);
                        statusStmt.setString(2, shortName);
                        statusStmt.setString(3, schema);
                    }
                    ResultSet rs = statusStmt.executeQuery();
                    result = rs.next() ? ((status = rs.getString(1)) != null && status.equals("VALID") ? 1 : 0) : 3;
                }
            }
            catch (SQLException e) {
                this.err(e, when);
            }
            return result;
        }
        if (this.type == 1002) {
            try {
                CallableStatement stmt = this.getState().getJarStatusStmt();
                stmt.setString(2, this.fullJarname);
                stmt.setString(3, this.schema);
                stmt.execute();
                return this.checkStatusStatus(stmt.getInt(1), stmt.getString(4));
            }
            catch (SQLException e) {
                this.err(e, this.mkMsg.m("getting status of {0}", this.toString()));
                return 3;
            }
        }
        return 2;
    }

    boolean invoke() {
        return this.getJdbc().invokeClass(this);
    }

    public boolean dropSynonym() {
        return this.getJdbc().dropSynonym(this);
    }

    Enumeration allGrants() {
        if (this.type == 29 || this.type == 30 || this.type == 28) {
            return this.getJdbc().allGrantees(this);
        }
        return null;
    }

    boolean definer(boolean flag) {
        if (this.type == 29 || this.type == 28) {
            return this.getJdbc().alterDefiner(this, flag);
        }
        return true;
    }

    boolean resolver(String spec) {
        if (this.type == 29 || this.type == 28) {
            return this.getJdbc().alterResolver(this, spec);
        }
        return true;
    }

    boolean useEbcdicShortening() {
        switch (this.type) {
            case 28: 
            case 29: 
            case 30: {
                boolean result = false;
                try {
                    PreparedStatement stmt = this.getState().getShortFromLongnameStmt();
                    stmt.setString(1, "java/lang/Object");
                    ResultSet rs = stmt.executeQuery();
                    if (rs.next()) {
                        result = rs.getString(1).equals("java/lang/Object");
                    }
                }
                catch (SQLException e) {
                    this.err(e, this.mkMsg.m("computing shortname of {0}", "foo"));
                }
                return !result;
            }
            case 1002: {
                return false;
            }
        }
        return true;
    }

    boolean isSysObj() {
        if (this.type == 29 || this.type == 30) {
            return this.getJdbc().isSysObj(this.getShortname(), this.type);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    boolean create() {
        boolean ok;
        block31: {
            ok = false;
            if (this.type != 1001) {
                ok = this.load();
            }
            if (this.type == 29) {
                if (ok) {
                    try {
                        CallableStatement stmt = this.getState().getClassCreationStmt();
                        stmt.setString(1, this.getOpts().andresolveClause());
                        stmt.setString(2, this.getOpts().schemaClause());
                        stmt.setString(3, this.getOpts().definerClause());
                        stmt.setString(4, this.getOpts().resolverClause());
                        stmt.setString(5, this.usingClause());
                        stmt.execute();
                        this.shortname = stmt.getString(6);
                    }
                    catch (SQLException e) {
                        this.err(e, this.mkMsg.m("creating class {0}", this.getName()));
                        ok = false;
                    }
                }
            } else if (this.type == 28) {
                if (ok) {
                    String name = this.getName();
                    try {
                        CallableStatement stmt = this.getState().getSourceCreationStmt();
                        stmt.setString(1, this.getOpts().getEncoding());
                        stmt.setString(2, name);
                        stmt.setString(3, this.getOpts().andresolveClause());
                        stmt.setString(4, this.getOpts().loadSchemaAsPrefix(name));
                        stmt.setString(5, this.getOpts().definerClause());
                        stmt.setString(6, this.getOpts().resolverClause());
                        stmt.setString(7, this.usingClause());
                        stmt.execute();
                        this.shortname = stmt.getString(8);
                    }
                    catch (SQLException e) {
                        ok = false;
                        this.err(e, this.mkMsg.m("creating source " + name));
                    }
                }
            } else if (this.type == 30) {
                String resourceName = this.getName();
                if (ok) {
                    try {
                        CallableStatement stmt = this.getState().getResourceCreationStmt();
                        stmt.setString(1, this.getOpts().loadSchemaAsPrefix(resourceName));
                        stmt.setString(2, this.usingClause());
                        stmt.execute();
                        this.shortname = stmt.getString(3);
                    }
                    catch (SQLException e) {
                        ok = false;
                        this.err(e, this.mkMsg.m("creating resource " + resourceName));
                    }
                }
            } else if (this.type == 1002) {
                if (ok) {
                    try {
                        CallableStatement stmt = this.getState().getStartLoadingJarStmt();
                        stmt.setString(1, "select LOB from " + this.lobTable(this.schema) + " where name ='" + this.getState().NameForLobTable + "'");
                        stmt.setString(3, this.fullJarname);
                        stmt.setString(4, this.schema);
                        stmt.setString(5, this.path);
                        stmt.setInt(6, 1 | (this.prependName ? 4 : 0) | (this.nested ? 8 : 0));
                        stmt.execute();
                        int status = stmt.getInt(2);
                        ok = this.checkStartLoadingStatus(status, this.schema, stmt.getString(7));
                    }
                    catch (SQLException e) {
                        this.err(e, this.mkMsg.m("creating {0}", this.toString()));
                        ok = false;
                    }
                }
            } else if (this.type == 1001) {
                Statement closeStmt;
                OracleCallableStatement copyStmt;
                OracleCallableStatement openStmt;
                String when;
                String filename = this.getName();
                InputStream input = this.getInputStream();
                if (input == null) {
                    this.err(this.mkMsg.m("cannot determine input stream"));
                    ok = false;
                } else {
                    when = this.mkMsg.m("deploying {0}", filename);
                    Connection conn = this.getConnection();
                    openStmt = null;
                    copyStmt = null;
                    closeStmt = null;
                    this.msg(this.mkMsg.m("deploying  : {0}", filename));
                    String openSQL = "{ call dbms_java.deploy_open(?,?) }";
                    openStmt = (OracleCallableStatement)conn.prepareCall(openSQL);
                    openStmt.setString(1, filename);
                    openStmt.registerOutParameter(2, 2004);
                    openStmt.execute();
                    BLOB blob = openStmt.getBLOB(2);
                    byte[] buffer = new byte[32000];
                    OutputStream blobOut = blob.getBinaryOutputStream();
                    new IOCopy().copy(blobOut, input);
                    blobOut.close();
                    String copySQL = "{ call dbms_java.deploy_copy(?) }";
                    copyStmt = (OracleCallableStatement)conn.prepareCall(copySQL);
                    copyStmt.setBLOB(1, blob);
                    copyStmt.execute();
                    ok = true;
                    this.closeStatement((Statement)openStmt, when);
                    this.closeStatement((Statement)copyStmt, when);
                    this.closeStatement(closeStmt, when);
                }
                break block31;
                catch (SQLException e) {
                    this.err(e, when);
                    ok = false;
                    break block31;
                }
                catch (IOException e2) {
                    this.err(e2, when);
                    ok = false;
                    break block31;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    this.closeStatement((Statement)openStmt, when);
                    this.closeStatement((Statement)copyStmt, when);
                    this.closeStatement(closeStmt, when);
                }
            }
        }
        return ok;
    }

    boolean resolve() {
        if (this.type == 28 || this.type == 29) {
            String name = this.getName();
            String qname = this.getPerhapsJarQualifiedName();
            String thing = this.type == 29 ? "class " : "source ";
            boolean ok = this.executeDDL("alter java " + thing + this.getOpts().loadSchemaAsPrefix(qname) + " compile", "resolving " + name);
            return ok;
        }
        return true;
    }

    boolean drop() {
        if (this.type == 29 || this.type == 30 || this.type == 28) {
            String name = this.getName();
            String qname = this.getPerhapsJarQualifiedName();
            String thing = null;
            switch (this.type) {
                case 29: {
                    thing = "class ";
                    break;
                }
                case 30: {
                    thing = "resource ";
                    break;
                }
                default: {
                    thing = "source ";
                }
            }
            boolean ok = this.executeDDL("drop java " + thing + this.getOpts().loadSchemaAsPrefix(qname), "dropping " + name);
            return ok;
        }
        if (this.type == 1002) {
            if (this.nested) {
                return true;
            }
            try {
                CallableStatement stmt = this.getState().getDropJarStmt();
                stmt.setString(2, this.getShortname());
                stmt.setString(3, this.schema);
                stmt.execute();
                return this.checkDropStatus(stmt.getInt(1), stmt.getString(4));
            }
            catch (SQLException e) {
                this.err(e, this.mkMsg.m("dropping {0}", this.toString()));
                return false;
            }
        }
        return true;
    }

    boolean revoke(String grantee) {
        String name = this.getName();
        String qname = this.getPerhapsJarQualifiedName();
        boolean ok = true;
        if (this.type == 29) {
            ok = this.executeDDL("revoke execute on java " + this.getOpts().loadSchemaAsPrefix(qname) + " from " + grantee, "revoking execute on " + name + " from " + grantee);
        } else if (this.type == 30) {
            ok = this.getJdbc().executeDDL("revoke execute on java resource " + this.getOpts().loadSchemaAsPrefix(qname) + " from " + grantee, "revoking execute on " + name + " from " + grantee);
        } else if (this.type == 28) {
            ok = this.getJdbc().executeDDL("revoke execute on java source " + this.getOpts().loadSchemaAsPrefix(qname) + " from " + grantee, "revoking execute on " + name + " from " + grantee);
            ok = this.getSourceHelper().depend_revoke(grantee) && ok;
        }
        return ok;
    }

    boolean grant(String grantee) {
        boolean ok;
        String name = this.getName();
        String qname = this.getPerhapsJarQualifiedName();
        if (this.type == 29) {
            ok = this.executeDDL("grant execute on " + this.getOpts().loadSchemaAsPrefix(qname) + " to " + grantee, "granting execute on " + name + " to " + grantee);
        } else if (this.type == 30) {
            ok = this.executeDDL("grant execute on java resource" + this.getOpts().loadSchemaAsPrefix(qname) + " to " + grantee, "granting execute on " + name + " to " + grantee);
        } else if (this.type == 28) {
            ok = this.executeDDL("grant execute on java source" + this.getOpts().schemaAsPrefix(this.getSchema()) + this.doubleQuote(qname) + " to " + grantee, "granting execute on " + name + " to " + grantee);
            Enumeration dependents = this.getSourceHelper().getDependentClasses().elements();
            while (dependents.hasMoreElements()) {
                SchemaObject dependent = (SchemaObject)dependents.nextElement();
                this.msg(this.mkMsg.m("granting : execute on {0} to {1}", dependent.toString(), grantee));
                ok = dependent.grant(grantee) && ok;
            }
        } else {
            ok = true;
        }
        return ok;
    }

    boolean synonym() {
        boolean ok = true;
        if (this.type == 29) {
            ok = this.getJdbc().synonym(this);
        } else if (this.type == 30) {
            ok = this.grant("PUBLIC");
        } else if (this.type == 28) {
            ok = this.getSourceHelper().synonym();
        }
        return ok;
    }

    String getName() {
        switch (this.type) {
            case 29: {
                if (this.name != null) break;
                this.name = this.getClassHelper().getClassName();
                if (this.name != null) break;
                this.name = this.getExternalName();
                break;
            }
            case 28: {
                if (this.name != null) break;
                String externalName = this.getExternalName();
                String encoding = this.getOptsForName(externalName).getEncoding();
                this.name = this.getSourceHelper().getSourceName(externalName, this.getRepeatableInputStream(), encoding);
                break;
            }
            case 1002: {
                this.name = this.fullJarname;
                break;
            }
            case 1001: {
                break;
            }
            default: {
                this.name = this.getExternalName();
            }
        }
        return this.name;
    }

    void endLoading() {
        if (this.type != 1002) {
            return;
        }
        try {
            CallableStatement stmt = this.getState().getEndLoadingJarStmt();
            stmt.setInt(2, 0);
            stmt.execute();
            this.checkEndLoadingStatus(stmt.getInt(1), stmt.getString(3));
        }
        catch (SQLException e) {
            this.err(e, this.mkMsg.m("creating {0}", this.toString()));
        }
    }

    void resumeLoading() {
        if (this.type != 1002) {
            return;
        }
        try {
            CallableStatement stmt = this.getState().getResumeLoadingJarStmt();
            stmt.setString(2, this.fullJarname);
            stmt.setString(3, this.schema);
            stmt.setString(4, this.path);
            stmt.setInt(5, 2);
            stmt.execute();
            this.checkResumeLoadingStatus(stmt.getInt(1), this.schema, stmt.getString(6));
        }
        catch (SQLException e) {
            this.err(e, this.mkMsg.m("creating {0}", this.toString()));
        }
    }

    boolean genMissing() {
        if (this.type == 28) {
            return this.getSourceHelper().genMissing();
        }
        if (this.type == 29) {
            return this.getClassHelper().genMissing();
        }
        return true;
    }

    boolean addPublish() {
        if (this.type == 28) {
            return this.getSourceHelper().addPublish();
        }
        if (this.type == 29) {
            return this.getClassHelper().addPublish();
        }
        return true;
    }
}

