/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.rdbms;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.StreamCorruptedException;
import java.lang.reflect.Array;
import oracle.aurora.rdbms.DbmsJava;
import oracle.aurora.rdbms.Schema;

public class DbmsObjectInputStream
extends ObjectInputStream {
    public DbmsObjectInputStream(InputStream in) throws IOException, StreamCorruptedException {
        super(in);
    }

    protected Class lookupClass(String classname, int schemaNumber) throws ClassNotFoundException {
        Schema schema = Schema.lookup(schemaNumber);
        if (schema == null) {
            throw new ClassNotFoundException(classname + " : The schema no longer exists");
        }
        return DbmsJava.classForNameAndSchema(classname, schema);
    }

    protected Class primitiveType(char type) {
        switch (type) {
            case 'B': {
                return Byte.TYPE;
            }
            case 'C': {
                return Character.TYPE;
            }
            case 'D': {
                return Double.TYPE;
            }
            case 'F': {
                return Float.TYPE;
            }
            case 'I': {
                return Integer.TYPE;
            }
            case 'J': {
                return Long.TYPE;
            }
            case 'S': {
                return Short.TYPE;
            }
            case 'Z': {
                return Boolean.TYPE;
            }
        }
        return null;
    }

    protected Class resolveClass(ObjectStreamClass classDesc) throws IOException, ClassNotFoundException {
        int schemaNumber = this.readInt();
        if (schemaNumber == -1) {
            return super.resolveClass(classDesc);
        }
        String cname = classDesc.getName();
        if (cname.startsWith("[")) {
            Class component;
            int dcount = 1;
            while (cname.charAt(dcount) == '[') {
                ++dcount;
            }
            if (cname.charAt(dcount) == 'L') {
                component = this.lookupClass(cname.substring(dcount + 1, cname.length() - 1), schemaNumber);
            } else {
                if (cname.length() != dcount + 1) {
                    throw new ClassNotFoundException(cname);
                }
                component = this.primitiveType(cname.charAt(dcount));
            }
            int[] dim = new int[dcount];
            for (int i = 0; i < dcount; ++i) {
                dim[i] = 0;
            }
            return Array.newInstance(component, dim).getClass();
        }
        return this.lookupClass(cname, schemaNumber);
    }
}

