/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.notinserver;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import oracle.aurora.compiler.Destination;

class FileDestination
implements Destination {
    String destDir;
    String name;
    File file;

    FileDestination(String d) {
        int ix = d.lastIndexOf(File.separatorChar);
        if (ix >= 0) {
            this.destDir = d.substring(0, ix);
            this.name = d.substring(ix + 1);
        } else {
            this.destDir = null;
            this.name = d;
        }
        this.destDir = this.destDir;
        this.name = this.name;
    }

    File getFile() throws IOException {
        if (this.file == null) {
            try {
                if (this.destDir != null) {
                    File dir = new File(this.destDir);
                    dir.mkdirs();
                    this.file = new File(dir, this.name);
                } else {
                    this.file = new File(this.name);
                }
            }
            catch (SecurityException e) {
                throw new FileNotFoundException(this.getPath());
            }
        }
        return this.file;
    }

    public OutputStream getStream() throws IOException {
        return new FileOutputStream(this.getFile());
    }

    public Writer getWriter() throws IOException {
        return new FileWriter(this.getFile());
    }

    public String getPath() {
        return this.destDir + File.separator + this.name;
    }

    public String toString() {
        return this.getPath();
    }
}

