/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.compiler;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import oracle.aurora.compiler.CompilerConnection;
import oracle.aurora.compiler.OptionTable;

public class JdbcOptionTable
extends OptionTable {
    String url;
    String what;
    Connection connection;
    Vector rows;
    Boolean exists;

    public JdbcOptionTable(Connection connection, String what) throws SQLException {
        this.connection = connection;
        this.setRows(what);
    }

    Connection getConnection() throws SQLException {
        if (this.connection == null) {
            this.connection = new CompilerConnection().getConnection();
        }
        return this.connection;
    }

    public JdbcOptionTable(Connection connection) throws SQLException {
        this(connection, null);
    }

    boolean tableExists() throws SQLException {
        if (this.exists == null) {
            Statement check = this.getConnection().createStatement();
            ResultSet r = check.executeQuery("SELECT TABLE_NAME FROM USER_TABLES WHERE TABLE_NAME = 'JAVA$OPTIONS'");
            this.exists = new Boolean(r.next());
            check.close();
        }
        return this.exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createTable() throws SQLException {
        if (!this.tableExists()) {
            try {
                Statement check = this.getConnection().createStatement();
                try {
                    check.execute("CREATE TABLE JAVA$OPTIONS ( WHAT VARCHAR2(128), OPT VARCHAR2(20), VALUE VARCHAR2(128))");
                }
                finally {
                    check.close();
                }
                this.exists = new Boolean(true);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Vector setRows(String what) throws SQLException {
        this.rows = new Vector();
        if (this.tableExists()) {
            String selectSQL = "SELECT WHAT, OPT, VALUE FROM JAVA$OPTIONS";
            PreparedStatement select = this.getConnection().prepareStatement(selectSQL);
            try {
                ResultSet results = select.executeQuery();
                while (results.next()) {
                    Row row = new Row(results.getString(1), results.getString(2), results.getString(3));
                    if (what != null && !what.startsWith(row.level)) continue;
                    this.rows.addElement(row);
                }
            }
            finally {
                select.close();
            }
        }
        return this.rows;
    }

    Vector getRows() {
        if (this.rows == null) {
            try {
                this.setRows(null);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return this.rows;
    }

    public Enumeration getValues(String level, String option) {
        return new SelectValues(level, option);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetValues(String what, String option) {
        block11: {
            if (what == null) {
                what = "";
            }
            SelectRows old = new SelectRows(what, option);
            Vector<Row> forDeletion = new Vector<Row>();
            while (old.hasMoreElements()) {
                Row row = (Row)old.nextElement();
                forDeletion.addElement(row);
            }
            Enumeration d = forDeletion.elements();
            while (d.hasMoreElements()) {
                Row row = (Row)d.nextElement();
                this.getRows().removeElement(row);
            }
            try {
                if (!this.tableExists()) break block11;
                PreparedStatement del = this.getConnection().prepareStatement("DELETE FROM JAVA$OPTIONS WHERE WHAT = ? AND OPT = ?");
                try {
                    del.setString(1, what);
                    del.setString(2, option);
                    del.execute();
                }
                finally {
                    del.close();
                }
                if (what != null && !what.equals("")) break block11;
                try {
                    PreparedStatement delNull = this.getConnection().prepareStatement("DELETE FROM JAVA$OPTIONS WHERE WHAT IS NULL AND OPT = ?");
                    delNull.setString(1, option);
                    delNull.execute();
                }
                finally {
                    del.close();
                }
            }
            catch (SQLException ex) {
                // empty catch block
            }
        }
    }

    public void addValue(String what, String option, String value) {
        Row row = new Row(what, option, value);
        this.rows.addElement(row);
        try {
            this.createTable();
            PreparedStatement add = this.getConnection().prepareStatement("INSERT INTO JAVA$OPTIONS VALUES(?, ?, ? )");
            add.setString(1, what);
            add.setString(2, option);
            add.setString(3, value);
            add.executeUpdate();
            add.close();
        }
        catch (SQLException ex) {
            // empty catch block
        }
    }

    class SelectValues
    extends SelectRows {
        SelectValues(String level, String option) {
            super(level, option);
        }

        public Object nextElement() {
            Row row = (Row)super.nextElement();
            return row.value;
        }
    }

    class SelectRows
    implements Enumeration {
        Enumeration all;
        Row nextRow;
        String level;
        String option;

        SelectRows(String level, String option) {
            this.all = JdbcOptionTable.this.getRows().elements();
            this.nextRow = null;
            this.level = level;
            this.option = option;
        }

        private void makeReady() {
            while (this.nextRow == null && this.all.hasMoreElements()) {
                Row row = (Row)this.all.nextElement();
                if (!row.level.equals(this.level) || !row.option.equals(this.option)) continue;
                this.nextRow = row;
            }
        }

        public boolean hasMoreElements() {
            this.makeReady();
            return this.nextRow != null;
        }

        public Object nextElement() {
            this.makeReady();
            if (this.nextRow != null) {
                Row result = this.nextRow;
                this.nextRow = null;
                return result;
            }
            throw new NoSuchElementException();
        }
    }

    class Row {
        String level;
        String option;
        String value;

        Row(String level, String option, String value) {
            this.level = level;
            if (this.level == null) {
                this.level = "";
            }
            this.option = option;
            this.value = value;
        }

        public String toString() {
            return "OptionRow(level " + this.level + ", option " + this.option + ", value " + this.value + ")";
        }
    }
}

