/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.storage;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import oracle.ojc.interfaces.Storage;
import oracle.ojc.storage.AbstractStorage;
import oracle.ojc.storage.FileStorage;

public class DirectoryStorage
extends AbstractStorage {
    HashMap entries = new HashMap();
    private boolean directoryRead;
    private boolean directoryResolved;
    private static Storage UNRESOLVED_STORAGE = new FileStorage(null);

    public DirectoryStorage(AbstractStorage storage, String name) {
        super(storage, name);
    }

    public DirectoryStorage(File file) {
        super(file);
    }

    Storage find(String fileName) {
        Storage storage = (Storage)this.entries.get(fileName);
        if (storage == UNRESOLVED_STORAGE) {
            storage = this.resolveStorage(this.file, fileName);
            this.entries.put(fileName, storage);
        }
        return storage;
    }

    private void readDirectory() {
        if (this.directoryRead) {
            return;
        }
        this.directoryRead = true;
        if (this.file == null) {
            return;
        }
        String[] fileNames = this.file.list();
        if (fileNames != null) {
            int i = fileNames.length;
            while (--i >= 0) {
                this.entries.put(fileNames[i], UNRESOLVED_STORAGE);
            }
        }
    }

    private void resolveDirectory() {
        if (this.directoryResolved) {
            return;
        }
        this.directoryResolved = true;
        if (this.file == null) {
            return;
        }
        Set entrySet = this.entries.entrySet();
        for (Map.Entry entry : entrySet) {
            if (entry.getValue() != UNRESOLVED_STORAGE) continue;
            entry.setValue(this.resolveStorage(this.file, (String)entry.getKey()));
        }
    }

    private Storage resolveStorage(File file, String name) {
        File fileFile = new File(file, name);
        if (fileFile.isDirectory()) {
            return new DirectoryStorage(fileFile);
        }
        return new FileStorage(fileFile);
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    @Override
    public Storage create(String name) throws IOException {
        FileStorage fileStorage = new FileStorage(this, name);
        fileStorage.out = new FileOutputStream(fileStorage.file);
        this.entries.put(name, fileStorage);
        return fileStorage;
    }

    @Override
    public Storage createDir(String name) throws IOException {
        Storage storage = this.open(name);
        if (storage != null) {
            return storage;
        }
        DirectoryStorage directoryStorage = new DirectoryStorage(this, name);
        directoryStorage.file.mkdir();
        this.entries.put(name, directoryStorage);
        return directoryStorage;
    }

    @Override
    public Storage open(String fileName) {
        if (fileName.endsWith("/")) {
            fileName = fileName.substring(0, fileName.length() - 1);
        }
        this.readDirectory();
        return this.find(fileName);
    }

    @Override
    public ArrayList listStorage() {
        this.readDirectory();
        this.resolveDirectory();
        return new ArrayList(this.entries.values());
    }
}

