/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.util;

import java.util.HashMap;
import java.util.StringTokenizer;

public class Version
implements Comparable {
    private static final HashMap _convertCache = new HashMap(100);
    private final int[] _numbers;
    private final String _versionLabel;

    public Version(String versionLabel) throws NumberFormatException {
        this._versionLabel = versionLabel;
        this._numbers = this.convert(versionLabel);
    }

    public Version(int[] numbers) {
        this._numbers = numbers;
        StringBuffer versionLabelBuffer = new StringBuffer();
        for (int i = 0; i < numbers.length; ++i) {
            if (i > 0) {
                versionLabelBuffer.append('.');
            }
            versionLabelBuffer.append(String.valueOf(numbers[i]));
        }
        this._versionLabel = versionLabelBuffer.toString();
    }

    public int[] toIntArray() {
        int[] numbers = new int[this._numbers.length];
        System.arraycopy(this._numbers, 0, numbers, 0, this._numbers.length);
        return numbers;
    }

    public int compareTo(Object other) {
        if (this == other) {
            return 0;
        }
        int[] otherNumbers = ((Version)other)._numbers;
        int len1 = this._numbers.length;
        int len2 = otherNumbers.length;
        int max = Math.max(len1, len2);
        for (int i = 0; i < max; ++i) {
            int d2;
            int d1 = i < len1 ? this._numbers[i] : 0;
            int n = d2 = i < len2 ? otherNumbers[i] : 0;
            if (d1 == d2) continue;
            return d1 - d2;
        }
        return 0;
    }

    public String toString() {
        return this._versionLabel;
    }

    public String toCanonicalString() {
        int len = this._numbers.length;
        StringBuffer rtn = new StringBuffer(len * 3).append(this._numbers[0]);
        for (int i = 1; i < len; ++i) {
            rtn.append('.');
            rtn.append(this._numbers[i]);
        }
        return rtn.toString();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Version)) {
            return false;
        }
        Version version = (Version)other;
        int len = this._numbers.length;
        if (len != version._numbers.length) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (this._numbers[i] == version._numbers[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 925295;
        int len = this._numbers.length;
        for (int i = 0; i < len; ++i) {
            hash = 37 * hash + i;
        }
        return hash;
    }

    private int[] convert(String versionLabel) throws NumberFormatException {
        int[] numbers = (int[])_convertCache.get(versionLabel);
        if (numbers != null) {
            return numbers;
        }
        StringTokenizer tokenizer = new StringTokenizer(versionLabel, ".", true);
        int count = tokenizer.countTokens() + 1;
        if (count % 2 != 0) {
            throw new NumberFormatException(" Malformed version specification: `" + versionLabel + "`.");
        }
        numbers = new int[count / 2];
        boolean expectingNumber = true;
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (expectingNumber) {
                expectingNumber = false;
                int piece = Integer.parseInt(token);
                if (piece < 0) {
                    throw new NumberFormatException("Malformed version specification: `" + piece + "`." + "Version number must be > 0.");
                }
                numbers[i++] = piece;
                continue;
            }
            expectingNumber = true;
        }
        return numbers;
    }
}

