/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.properties;

import oracle.javatools.parser.AbstractLexer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.properties.DefaultPropertyFileLexerSetup;
import oracle.javatools.parser.properties.DefinitionTokens;
import oracle.javatools.parser.properties.PropertyFileLexerSetup;

public class DefinitionLexer
extends AbstractLexer
implements DefinitionTokens {
    private int lastToken = -1;
    private int startOffset = -1;
    private int endOffset = -1;
    private boolean useLastToken = false;
    private boolean skipSymbols = false;
    private int nextTokenType;
    private final PropertyFileLexerSetup lexerSetup;

    public DefinitionLexer() {
        this(DefaultPropertyFileLexerSetup.INSTANCE);
    }

    public DefinitionLexer(PropertyFileLexerSetup lexerSetup) {
        this.setTextBuffer(null);
        this.setPosition(0);
        this.nextTokenType = 21;
        this.lexerSetup = lexerSetup;
    }

    public void setSkipSymbols(boolean skipSymbols) {
        this.skipSymbols = skipSymbols;
    }

    @Override
    public int lex(LexerToken lexedToken) {
        block13: {
            if (this.useLastToken) {
                this.useLastToken = false;
                return this.fillLexerToken(lexedToken);
            }
            this.lastToken = 0;
            try {
                block7: while (true) {
                    char c = this.textBuffer.getChar(this.currentPos++);
                    this.startOffset = this.currentPos - 1;
                    if (this.lexerSetup.isEndOfLineOfPropertyDefinition(c, this.textBuffer, this.currentPos)) {
                        this.nextTokenType = 0;
                        break;
                    }
                    if (Character.isWhitespace(c)) {
                        this.skipNonEOLWhitespace();
                        continue;
                    }
                    switch (this.nextTokenType) {
                        case 21: {
                            --this.currentPos;
                            this.lastToken = 21;
                            this.nextTokenType = 23;
                            this.skipName();
                            break block7;
                        }
                        case 23: {
                            if (c == '=' || c == ':') {
                                this.lastToken = 23;
                                this.nextTokenType = 22;
                                if (this.skipSymbols) {
                                    this.lastToken = 0;
                                    continue block7;
                                }
                                break block13;
                            }
                        }
                        case 22: {
                            --this.currentPos;
                            this.lastToken = 22;
                            this.nextTokenType = 0;
                            this.skipValue();
                            break block7;
                        }
                        default: {
                            throw new IllegalStateException("unexpected next: " + this.nextTokenType);
                        }
                    }
                    break;
                }
            }
            catch (IndexOutOfBoundsException e) {
                this.currentPos = this.textBuffer.getLength();
                if (this.lastToken != 0) break block13;
                this.startOffset = this.currentPos;
            }
        }
        this.endOffset = this.currentPos;
        this.useLastToken = false;
        return this.fillLexerToken(lexedToken);
    }

    private void skipName() {
        while (true) {
            char c;
            if (Character.isWhitespace(c = this.textBuffer.getChar(this.currentPos++)) || c == '=' || c == ':') {
                --this.currentPos;
                return;
            }
            if (!this.lexerSetup.isBreakInLineOfPropertyDefinition(c, this.textBuffer, this.currentPos)) continue;
            ++this.currentPos;
        }
    }

    private void skipValue() {
        while (true) {
            char c;
            if (this.lexerSetup.isBreakInLineOfPropertyDefinition(c = this.textBuffer.getChar(this.currentPos++), this.textBuffer, this.currentPos)) {
                ++this.currentPos;
                continue;
            }
            if (this.lexerSetup.isEndOfLineOfPropertyDefinition(c, this.textBuffer, this.currentPos)) break;
        }
        --this.currentPos;
    }

    private void skipNonEOLWhitespace() {
        char c;
        while ((c = this.textBuffer.getChar(this.currentPos++)) != '\n' && Character.isWhitespace(c)) {
        }
        --this.currentPos;
    }

    @Override
    public void backup() {
        this.useLastToken = true;
    }

    @Override
    public void setPosition(int offset) {
        super.setPosition(offset);
        this.nextTokenType = 21;
        this.useLastToken = false;
    }

    private int fillLexerToken(LexerToken lexedToken) {
        AbstractLexer.DefaultLexerToken outToken = (AbstractLexer.DefaultLexerToken)lexedToken;
        outToken.setToken(this.lastToken);
        outToken.setStartOffset(this.startOffset);
        outToken.setEndOffset(this.endOffset);
        return this.lastToken;
    }

    public static String tokenToString(int token) {
        switch (token) {
            case 21: {
                return "TK_NAME";
            }
            case 22: {
                return "TK_VALUE";
            }
            case 23: {
                return "TK_SYMBOL";
            }
        }
        return "**UNKNOWN**";
    }

    public static String tokenToText(int token) {
        switch (token) {
            case 21: {
                return "Property Name";
            }
            case 22: {
                return "Property Value";
            }
            case 23: {
                return "Assignment Operator";
            }
        }
        return "**UNKNOWN**";
    }
}

