/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.plsql.symtab;

import oracle.javatools.parser.plsql.data.PlsqlError;
import oracle.javatools.parser.plsql.data.PlsqlNode;
import oracle.javatools.parser.plsql.data.PlsqlRoot;
import oracle.javatools.parser.plsql.symtab.Ptnod;
import oracle.javatools.parser.plsql.symtab.PtnodError;

public class PtnodRoot
extends Ptnod
implements PlsqlRoot {
    private PlsqlError[] errors = null;
    private PlsqlNode[] units = null;

    @Override
    public PlsqlError[] getErrors() {
        if (this.errors == null) {
            this.convertErrors();
        }
        return this.errors;
    }

    @Override
    public PlsqlNode[] getUnits() {
        if (this.units == null) {
            this.convertUnits();
        }
        return this.units;
    }

    private void convertErrors() {
        int count = 0;
        for (int i = 0; i < this.kidCount; ++i) {
            if (this.kids[i].getTreeKind() != 2) continue;
            ++count;
        }
        if (count > 0) {
            this.errors = new PlsqlError[count];
            int index = 0;
            for (int i = 0; i < this.kidCount; ++i) {
                if (this.kids[i].getTreeKind() == 2) {
                    this.errors[index++] = (PlsqlError)this.kids[i];
                }
                if (index != count) {
                    continue;
                }
                break;
            }
        } else {
            this.errors = PtnodError.EMPTY_ARRAY;
        }
    }

    private void convertUnits() {
        int count = 0;
        for (int i = 0; i < this.kidCount; ++i) {
            switch (this.kids[i].getTreeKind()) {
                case 17: 
                case 18: 
                case 19: 
                case 22: 
                case 24: {
                    ++count;
                }
            }
        }
        if (count > 0) {
            this.units = new PlsqlNode[count];
            int index = 0;
            for (int i = 0; i < this.kidCount; ++i) {
                switch (this.kids[i].getTreeKind()) {
                    case 17: 
                    case 18: 
                    case 19: 
                    case 22: 
                    case 24: {
                        this.units[index++] = this.kids[i];
                    }
                }
                if (index != count) {
                    continue;
                }
                break;
            }
        } else {
            this.units = Ptnod.EMPTY_ARRAY;
        }
    }

    @Override
    protected void verify() {
        this.convertUnits();
        this.convertErrors();
    }
}

